/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.FleetResourceProperties;
import com.azure.resourcemanager.cosmos.models.Status;
import java.io.IOException;

public final class FleetResourceUpdate
implements JsonSerializable<FleetResourceUpdate> {
    private FleetResourceProperties innerProperties;

    private FleetResourceProperties innerProperties() {
        return this.innerProperties;
    }

    public Status provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public FleetResourceUpdate withProvisioningState(Status provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetResourceProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static FleetResourceUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (FleetResourceUpdate)jsonReader.readObject(reader -> {
            FleetResourceUpdate deserializedFleetResourceUpdate = new FleetResourceUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedFleetResourceUpdate.innerProperties = FleetResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFleetResourceUpdate;
        });
    }
}

