/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.RestorableTableResourcesClient;
import com.azure.resourcemanager.cosmos.fluent.models.RestorableTableResourcesGetResultInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.RestorableTableResourcesListResult;
import reactor.core.publisher.Mono;

public final class RestorableTableResourcesClientImpl
implements RestorableTableResourcesClient {
    private final RestorableTableResourcesService service;
    private final CosmosDBManagementClientImpl client;

    RestorableTableResourcesClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (RestorableTableResourcesService)RestProxy.create(RestorableTableResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RestorableTableResourcesGetResultInner>> listSinglePageAsync(String location, String instanceId, String restoreLocation, String restoreTimestampInUtc) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, instanceId, restoreLocation, restoreTimestampInUtc, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RestorableTableResourcesListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RestorableTableResourcesGetResultInner>> listSinglePageAsync(String location, String instanceId, String restoreLocation, String restoreTimestampInUtc, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, instanceId, restoreLocation, restoreTimestampInUtc, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RestorableTableResourcesListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RestorableTableResourcesGetResultInner> listAsync(String location, String instanceId, String restoreLocation, String restoreTimestampInUtc) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, instanceId, restoreLocation, restoreTimestampInUtc));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RestorableTableResourcesGetResultInner> listAsync(String location, String instanceId) {
        String restoreLocation = null;
        String restoreTimestampInUtc = null;
        return new PagedFlux(() -> this.listSinglePageAsync(location, instanceId, restoreLocation, restoreTimestampInUtc));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RestorableTableResourcesGetResultInner> listAsync(String location, String instanceId, String restoreLocation, String restoreTimestampInUtc, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, instanceId, restoreLocation, restoreTimestampInUtc, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RestorableTableResourcesGetResultInner> list(String location, String instanceId) {
        String restoreLocation = null;
        String restoreTimestampInUtc = null;
        return new PagedIterable(this.listAsync(location, instanceId, restoreLocation, restoreTimestampInUtc));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RestorableTableResourcesGetResultInner> list(String location, String instanceId, String restoreLocation, String restoreTimestampInUtc, Context context) {
        return new PagedIterable(this.listAsync(location, instanceId, restoreLocation, restoreTimestampInUtc, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementClientRestorableTableResources")
    public static interface RestorableTableResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{instanceId}/restorableTableResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RestorableTableResourcesListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @PathParam(value="instanceId") String var5, @QueryParam(value="restoreLocation") String var6, @QueryParam(value="restoreTimestampInUtc") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

