/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.FleetspaceAccountPropertiesGlobalDatabaseAccountProperties;
import com.azure.resourcemanager.cosmos.models.Status;
import java.io.IOException;

public final class FleetspaceAccountProperties
implements JsonSerializable<FleetspaceAccountProperties> {
    private Status provisioningState;
    private FleetspaceAccountPropertiesGlobalDatabaseAccountProperties globalDatabaseAccountProperties;

    public Status provisioningState() {
        return this.provisioningState;
    }

    public FleetspaceAccountProperties withProvisioningState(Status provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public FleetspaceAccountPropertiesGlobalDatabaseAccountProperties globalDatabaseAccountProperties() {
        return this.globalDatabaseAccountProperties;
    }

    public FleetspaceAccountProperties withGlobalDatabaseAccountProperties(FleetspaceAccountPropertiesGlobalDatabaseAccountProperties globalDatabaseAccountProperties) {
        this.globalDatabaseAccountProperties = globalDatabaseAccountProperties;
        return this;
    }

    public void validate() {
        if (this.globalDatabaseAccountProperties() != null) {
            this.globalDatabaseAccountProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeJsonField("globalDatabaseAccountProperties", (JsonSerializable)this.globalDatabaseAccountProperties);
        return jsonWriter.writeEndObject();
    }

    public static FleetspaceAccountProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FleetspaceAccountProperties)jsonReader.readObject(reader -> {
            FleetspaceAccountProperties deserializedFleetspaceAccountProperties = new FleetspaceAccountProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedFleetspaceAccountProperties.provisioningState = Status.fromString(reader.getString());
                    continue;
                }
                if ("globalDatabaseAccountProperties".equals(fieldName)) {
                    deserializedFleetspaceAccountProperties.globalDatabaseAccountProperties = FleetspaceAccountPropertiesGlobalDatabaseAccountProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFleetspaceAccountProperties;
        });
    }
}

