/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.VectorIndexType;
import java.io.IOException;
import java.util.List;

public final class VectorIndex
implements JsonSerializable<VectorIndex> {
    private String path;
    private VectorIndexType type;
    private Long quantizationByteSize;
    private Long indexingSearchListSize;
    private List<String> vectorIndexShardKey;
    private static final ClientLogger LOGGER = new ClientLogger(VectorIndex.class);

    public String path() {
        return this.path;
    }

    public VectorIndex withPath(String path) {
        this.path = path;
        return this;
    }

    public VectorIndexType type() {
        return this.type;
    }

    public VectorIndex withType(VectorIndexType type) {
        this.type = type;
        return this;
    }

    public Long quantizationByteSize() {
        return this.quantizationByteSize;
    }

    public VectorIndex withQuantizationByteSize(Long quantizationByteSize) {
        this.quantizationByteSize = quantizationByteSize;
        return this;
    }

    public Long indexingSearchListSize() {
        return this.indexingSearchListSize;
    }

    public VectorIndex withIndexingSearchListSize(Long indexingSearchListSize) {
        this.indexingSearchListSize = indexingSearchListSize;
        return this;
    }

    public List<String> vectorIndexShardKey() {
        return this.vectorIndexShardKey;
    }

    public VectorIndex withVectorIndexShardKey(List<String> vectorIndexShardKey) {
        this.vectorIndexShardKey = vectorIndexShardKey;
        return this;
    }

    public void validate() {
        if (this.path() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property path in model VectorIndex"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model VectorIndex"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeNumberField("quantizationByteSize", (Number)this.quantizationByteSize);
        jsonWriter.writeNumberField("indexingSearchListSize", (Number)this.indexingSearchListSize);
        jsonWriter.writeArrayField("vectorIndexShardKey", this.vectorIndexShardKey, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VectorIndex fromJson(JsonReader jsonReader) throws IOException {
        return (VectorIndex)jsonReader.readObject(reader -> {
            VectorIndex deserializedVectorIndex = new VectorIndex();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedVectorIndex.path = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVectorIndex.type = VectorIndexType.fromString(reader.getString());
                    continue;
                }
                if ("quantizationByteSize".equals(fieldName)) {
                    deserializedVectorIndex.quantizationByteSize = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("indexingSearchListSize".equals(fieldName)) {
                    deserializedVectorIndex.indexingSearchListSize = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("vectorIndexShardKey".equals(fieldName)) {
                    List vectorIndexShardKey;
                    deserializedVectorIndex.vectorIndexShardKey = vectorIndexShardKey = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVectorIndex;
        });
    }
}

