/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.DataType;
import com.azure.resourcemanager.cosmos.models.IndexKind;
import java.io.IOException;

public final class Indexes
implements JsonSerializable<Indexes> {
    private DataType dataType;
    private Integer precision;
    private IndexKind kind;

    public DataType dataType() {
        return this.dataType;
    }

    public Indexes withDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public Integer precision() {
        return this.precision;
    }

    public Indexes withPrecision(Integer precision) {
        this.precision = precision;
        return this;
    }

    public IndexKind kind() {
        return this.kind;
    }

    public Indexes withKind(IndexKind kind) {
        this.kind = kind;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        jsonWriter.writeNumberField("precision", (Number)this.precision);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static Indexes fromJson(JsonReader jsonReader) throws IOException {
        return (Indexes)jsonReader.readObject(reader -> {
            Indexes deserializedIndexes = new Indexes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataType".equals(fieldName)) {
                    deserializedIndexes.dataType = DataType.fromString(reader.getString());
                    continue;
                }
                if ("precision".equals(fieldName)) {
                    deserializedIndexes.precision = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedIndexes.kind = IndexKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIndexes;
        });
    }
}

