/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.RestorableSqlDatabasesClient;
import com.azure.resourcemanager.cosmos.fluent.models.RestorableSqlDatabaseGetResultInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.RestorableSqlDatabasesListResult;
import reactor.core.publisher.Mono;

public final class RestorableSqlDatabasesClientImpl
implements RestorableSqlDatabasesClient {
    private final RestorableSqlDatabasesService service;
    private final CosmosDBManagementClientImpl client;

    RestorableSqlDatabasesClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (RestorableSqlDatabasesService)RestProxy.create(RestorableSqlDatabasesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RestorableSqlDatabaseGetResultInner>> listSinglePageAsync(String location, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, instanceId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RestorableSqlDatabasesListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RestorableSqlDatabaseGetResultInner>> listSinglePageAsync(String location, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, instanceId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RestorableSqlDatabasesListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RestorableSqlDatabaseGetResultInner> listAsync(String location, String instanceId) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, instanceId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RestorableSqlDatabaseGetResultInner> listAsync(String location, String instanceId, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, instanceId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RestorableSqlDatabaseGetResultInner> list(String location, String instanceId) {
        return new PagedIterable(this.listAsync(location, instanceId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RestorableSqlDatabaseGetResultInner> list(String location, String instanceId, Context context) {
        return new PagedIterable(this.listAsync(location, instanceId, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementClientRestorableSqlDatabases")
    public static interface RestorableSqlDatabasesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{instanceId}/restorableSqlDatabases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RestorableSqlDatabasesListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @PathParam(value="instanceId") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

