/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.FleetspacesClient;
import com.azure.resourcemanager.cosmos.fluent.models.FleetspaceResourceInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.FleetspaceListResult;
import com.azure.resourcemanager.cosmos.models.FleetspaceUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FleetspacesClientImpl
implements FleetspacesClient {
    private final FleetspacesService service;
    private final CosmosDBManagementClientImpl client;

    FleetspacesClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (FleetspacesService)RestProxy.create(FleetspacesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceResourceInner>> listSinglePageAsync(String resourceGroupName, String fleetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FleetspaceListResult)res.getValue()).value(), ((FleetspaceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceResourceInner>> listSinglePageAsync(String resourceGroupName, String fleetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FleetspaceListResult)res.getValue()).value(), ((FleetspaceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FleetspaceResourceInner> listAsync(String resourceGroupName, String fleetName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, fleetName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<FleetspaceResourceInner> listAsync(String resourceGroupName, String fleetName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, fleetName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FleetspaceResourceInner> list(String resourceGroupName, String fleetName) {
        return new PagedIterable(this.listAsync(resourceGroupName, fleetName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FleetspaceResourceInner> list(String resourceGroupName, String fleetName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, fleetName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FleetspaceResourceInner>> getWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FleetspaceResourceInner>> getWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FleetspaceResourceInner> getAsync(String resourceGroupName, String fleetName, String fleetspaceName) {
        return this.getWithResponseAsync(resourceGroupName, fleetName, fleetspaceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((FleetspaceResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FleetspaceResourceInner> getWithResponse(String resourceGroupName, String fleetName, String fleetspaceName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FleetspaceResourceInner get(String resourceGroupName, String fleetName, String fleetspaceName) {
        return (FleetspaceResourceInner)((Object)this.getWithResponse(resourceGroupName, fleetName, fleetspaceName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginCreateAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, body);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)FleetspaceResourceInner.class), (Type)((Object)FleetspaceResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginCreateAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, body, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)FleetspaceResourceInner.class), (Type)((Object)FleetspaceResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginCreate(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body) {
        return this.beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginCreate(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body, Context context) {
        return this.beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, body, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FleetspaceResourceInner> createAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body) {
        return this.beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, body).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<FleetspaceResourceInner> createAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body, Context context) {
        return this.beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, body, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FleetspaceResourceInner create(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body) {
        return (FleetspaceResourceInner)((Object)this.createAsync(resourceGroupName, fleetName, fleetspaceName, body).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FleetspaceResourceInner create(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body, Context context) {
        return (FleetspaceResourceInner)((Object)this.createAsync(resourceGroupName, fleetName, fleetspaceName, body, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceUpdate body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceUpdate body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginUpdateAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceUpdate body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, body);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)FleetspaceResourceInner.class), (Type)((Object)FleetspaceResourceInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginUpdateAsync(String resourceGroupName, String fleetName, String fleetspaceName) {
        FleetspaceUpdate body = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, body);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)FleetspaceResourceInner.class), (Type)((Object)FleetspaceResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginUpdateAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceUpdate body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, body, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)FleetspaceResourceInner.class), (Type)((Object)FleetspaceResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginUpdate(String resourceGroupName, String fleetName, String fleetspaceName) {
        FleetspaceUpdate body = null;
        return this.beginUpdateAsync(resourceGroupName, fleetName, fleetspaceName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginUpdate(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceUpdate body, Context context) {
        return this.beginUpdateAsync(resourceGroupName, fleetName, fleetspaceName, body, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FleetspaceResourceInner> updateAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceUpdate body) {
        return this.beginUpdateAsync(resourceGroupName, fleetName, fleetspaceName, body).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FleetspaceResourceInner> updateAsync(String resourceGroupName, String fleetName, String fleetspaceName) {
        FleetspaceUpdate body = null;
        return this.beginUpdateAsync(resourceGroupName, fleetName, fleetspaceName, body).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<FleetspaceResourceInner> updateAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceUpdate body, Context context) {
        return this.beginUpdateAsync(resourceGroupName, fleetName, fleetspaceName, body, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FleetspaceResourceInner update(String resourceGroupName, String fleetName, String fleetspaceName) {
        FleetspaceUpdate body = null;
        return (FleetspaceResourceInner)((Object)this.updateAsync(resourceGroupName, fleetName, fleetspaceName, body).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FleetspaceResourceInner update(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceUpdate body, Context context) {
        return (FleetspaceResourceInner)((Object)this.updateAsync(resourceGroupName, fleetName, fleetspaceName, body, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String fleetName, String fleetspaceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, fleetName, fleetspaceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String fleetName, String fleetspaceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName, String fleetspaceName) {
        return this.beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName, String fleetspaceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String fleetName, String fleetspaceName) {
        return this.beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String fleetName, String fleetspaceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String fleetName, String fleetspaceName) {
        this.deleteAsync(resourceGroupName, fleetName, fleetspaceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String fleetName, String fleetspaceName, Context context) {
        this.deleteAsync(resourceGroupName, fleetName, fleetspaceName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FleetspaceListResult)res.getValue()).value(), ((FleetspaceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FleetspaceListResult)res.getValue()).value(), ((FleetspaceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementClientFleetspaces")
    public static interface FleetspacesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FleetspaceListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="fleetName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FleetspaceResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="fleetName") String var4, @PathParam(value="fleetspaceName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="fleetName") String var4, @PathParam(value="fleetspaceName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") FleetspaceResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="fleetName") String var4, @PathParam(value="fleetspaceName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") FleetspaceUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="fleetName") String var4, @PathParam(value="fleetspaceName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FleetspaceListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

