/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.FleetspaceAccountsClient;
import com.azure.resourcemanager.cosmos.fluent.models.FleetspaceAccountResourceInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.FleetspaceAccountListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FleetspaceAccountsClientImpl
implements FleetspaceAccountsClient {
    private final FleetspaceAccountsService service;
    private final CosmosDBManagementClientImpl client;

    FleetspaceAccountsClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (FleetspaceAccountsService)RestProxy.create(FleetspaceAccountsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceAccountResourceInner>> listSinglePageAsync(String resourceGroupName, String fleetName, String fleetspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FleetspaceAccountListResult)res.getValue()).value(), ((FleetspaceAccountListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceAccountResourceInner>> listSinglePageAsync(String resourceGroupName, String fleetName, String fleetspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FleetspaceAccountListResult)res.getValue()).value(), ((FleetspaceAccountListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FleetspaceAccountResourceInner> listAsync(String resourceGroupName, String fleetName, String fleetspaceName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, fleetName, fleetspaceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<FleetspaceAccountResourceInner> listAsync(String resourceGroupName, String fleetName, String fleetspaceName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, fleetName, fleetspaceName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FleetspaceAccountResourceInner> list(String resourceGroupName, String fleetName, String fleetspaceName) {
        return new PagedIterable(this.listAsync(resourceGroupName, fleetName, fleetspaceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FleetspaceAccountResourceInner> list(String resourceGroupName, String fleetName, String fleetspaceName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, fleetName, fleetspaceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FleetspaceAccountResourceInner>> getWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (fleetspaceAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceAccountName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FleetspaceAccountResourceInner>> getWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (fleetspaceAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceAccountName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FleetspaceAccountResourceInner> getAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName) {
        return this.getWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((FleetspaceAccountResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FleetspaceAccountResourceInner> getWithResponse(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FleetspaceAccountResourceInner get(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName) {
        return (FleetspaceAccountResourceInner)((Object)this.getWithResponse(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (fleetspaceAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceAccountName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, this.client.getApiVersion(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (fleetspaceAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceAccountName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, this.client.getApiVersion(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<FleetspaceAccountResourceInner>, FleetspaceAccountResourceInner> beginCreateAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)FleetspaceAccountResourceInner.class), (Type)((Object)FleetspaceAccountResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<FleetspaceAccountResourceInner>, FleetspaceAccountResourceInner> beginCreateAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)FleetspaceAccountResourceInner.class), (Type)((Object)FleetspaceAccountResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FleetspaceAccountResourceInner>, FleetspaceAccountResourceInner> beginCreate(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body) {
        return this.beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FleetspaceAccountResourceInner>, FleetspaceAccountResourceInner> beginCreate(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body, Context context) {
        return this.beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FleetspaceAccountResourceInner> createAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body) {
        return this.beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<FleetspaceAccountResourceInner> createAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body, Context context) {
        return this.beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FleetspaceAccountResourceInner create(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body) {
        return (FleetspaceAccountResourceInner)((Object)this.createAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FleetspaceAccountResourceInner create(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body, Context context) {
        return (FleetspaceAccountResourceInner)((Object)this.createAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (fleetspaceAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceAccountName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (fleetspaceAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetspaceAccountName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName) {
        return this.beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName) {
        return this.beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName) {
        this.deleteAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName, Context context) {
        this.deleteAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceAccountResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FleetspaceAccountListResult)res.getValue()).value(), ((FleetspaceAccountListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceAccountResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FleetspaceAccountListResult)res.getValue()).value(), ((FleetspaceAccountListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementClientFleetspaceAccounts")
    public static interface FleetspaceAccountsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}/fleetspaceAccounts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FleetspaceAccountListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="fleetName") String var4, @PathParam(value="fleetspaceName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}/fleetspaceAccounts/{fleetspaceAccountName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FleetspaceAccountResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="fleetName") String var4, @PathParam(value="fleetspaceName") String var5, @PathParam(value="fleetspaceAccountName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}/fleetspaceAccounts/{fleetspaceAccountName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="fleetName") String var4, @PathParam(value="fleetspaceName") String var5, @PathParam(value="fleetspaceAccountName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") FleetspaceAccountResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}/fleetspaceAccounts/{fleetspaceAccountName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="fleetName") String var4, @PathParam(value="fleetspaceName") String var5, @PathParam(value="fleetspaceAccountName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FleetspaceAccountListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

