/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.FleetspacePropertiesFleetspaceApiKind;
import com.azure.resourcemanager.cosmos.models.FleetspacePropertiesServiceTier;
import com.azure.resourcemanager.cosmos.models.FleetspacePropertiesThroughputPoolConfiguration;
import com.azure.resourcemanager.cosmos.models.Status;
import java.io.IOException;
import java.util.List;

public final class FleetspaceProperties
implements JsonSerializable<FleetspaceProperties> {
    private Status provisioningState;
    private FleetspacePropertiesFleetspaceApiKind fleetspaceApiKind;
    private FleetspacePropertiesServiceTier serviceTier;
    private List<String> dataRegions;
    private FleetspacePropertiesThroughputPoolConfiguration throughputPoolConfiguration;

    public Status provisioningState() {
        return this.provisioningState;
    }

    public FleetspaceProperties withProvisioningState(Status provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public FleetspacePropertiesFleetspaceApiKind fleetspaceApiKind() {
        return this.fleetspaceApiKind;
    }

    public FleetspaceProperties withFleetspaceApiKind(FleetspacePropertiesFleetspaceApiKind fleetspaceApiKind) {
        this.fleetspaceApiKind = fleetspaceApiKind;
        return this;
    }

    public FleetspacePropertiesServiceTier serviceTier() {
        return this.serviceTier;
    }

    public FleetspaceProperties withServiceTier(FleetspacePropertiesServiceTier serviceTier) {
        this.serviceTier = serviceTier;
        return this;
    }

    public List<String> dataRegions() {
        return this.dataRegions;
    }

    public FleetspaceProperties withDataRegions(List<String> dataRegions) {
        this.dataRegions = dataRegions;
        return this;
    }

    public FleetspacePropertiesThroughputPoolConfiguration throughputPoolConfiguration() {
        return this.throughputPoolConfiguration;
    }

    public FleetspaceProperties withThroughputPoolConfiguration(FleetspacePropertiesThroughputPoolConfiguration throughputPoolConfiguration) {
        this.throughputPoolConfiguration = throughputPoolConfiguration;
        return this;
    }

    public void validate() {
        if (this.throughputPoolConfiguration() != null) {
            this.throughputPoolConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeStringField("fleetspaceApiKind", this.fleetspaceApiKind == null ? null : this.fleetspaceApiKind.toString());
        jsonWriter.writeStringField("serviceTier", this.serviceTier == null ? null : this.serviceTier.toString());
        jsonWriter.writeArrayField("dataRegions", this.dataRegions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("throughputPoolConfiguration", (JsonSerializable)this.throughputPoolConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static FleetspaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FleetspaceProperties)jsonReader.readObject(reader -> {
            FleetspaceProperties deserializedFleetspaceProperties = new FleetspaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedFleetspaceProperties.provisioningState = Status.fromString(reader.getString());
                    continue;
                }
                if ("fleetspaceApiKind".equals(fieldName)) {
                    deserializedFleetspaceProperties.fleetspaceApiKind = FleetspacePropertiesFleetspaceApiKind.fromString(reader.getString());
                    continue;
                }
                if ("serviceTier".equals(fieldName)) {
                    deserializedFleetspaceProperties.serviceTier = FleetspacePropertiesServiceTier.fromString(reader.getString());
                    continue;
                }
                if ("dataRegions".equals(fieldName)) {
                    List dataRegions;
                    deserializedFleetspaceProperties.dataRegions = dataRegions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("throughputPoolConfiguration".equals(fieldName)) {
                    deserializedFleetspaceProperties.throughputPoolConfiguration = FleetspacePropertiesThroughputPoolConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFleetspaceProperties;
        });
    }
}

