// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The GremlinGraphGetPropertiesResource model.
 */
@Fluent
public final class GremlinGraphGetPropertiesResource extends GremlinGraphResource {
    /*
     * A system generated property. A unique identifier.
     */
    private String rid;

    /*
     * A system generated property that denotes the last updated timestamp of the resource.
     */
    private Float ts;

    /*
     * A system generated property representing the resource etag required for optimistic concurrency control.
     */
    private String etag;

    /**
     * Creates an instance of GremlinGraphGetPropertiesResource class.
     */
    public GremlinGraphGetPropertiesResource() {
    }

    /**
     * Get the rid property: A system generated property. A unique identifier.
     * 
     * @return the rid value.
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Get the ts property: A system generated property that denotes the last updated timestamp of the resource.
     * 
     * @return the ts value.
     */
    public Float ts() {
        return this.ts;
    }

    /**
     * Get the etag property: A system generated property representing the resource etag required for optimistic
     * concurrency control.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinGraphGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinGraphGetPropertiesResource withIndexingPolicy(IndexingPolicy indexingPolicy) {
        super.withIndexingPolicy(indexingPolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinGraphGetPropertiesResource withPartitionKey(ContainerPartitionKey partitionKey) {
        super.withPartitionKey(partitionKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinGraphGetPropertiesResource withDefaultTtl(Integer defaultTtl) {
        super.withDefaultTtl(defaultTtl);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinGraphGetPropertiesResource withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        super.withUniqueKeyPolicy(uniqueKeyPolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinGraphGetPropertiesResource
        withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        super.withConflictResolutionPolicy(conflictResolutionPolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinGraphGetPropertiesResource withAnalyticalStorageTtl(Long analyticalStorageTtl) {
        super.withAnalyticalStorageTtl(analyticalStorageTtl);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinGraphGetPropertiesResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        super.withRestoreParameters(restoreParameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinGraphGetPropertiesResource withCreateMode(CreateMode createMode) {
        super.withCreateMode(createMode);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property id in model GremlinGraphGetPropertiesResource"));
        }
        if (indexingPolicy() != null) {
            indexingPolicy().validate();
        }
        if (partitionKey() != null) {
            partitionKey().validate();
        }
        if (uniqueKeyPolicy() != null) {
            uniqueKeyPolicy().validate();
        }
        if (conflictResolutionPolicy() != null) {
            conflictResolutionPolicy().validate();
        }
        if (restoreParameters() != null) {
            restoreParameters().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GremlinGraphGetPropertiesResource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("indexingPolicy", indexingPolicy());
        jsonWriter.writeJsonField("partitionKey", partitionKey());
        jsonWriter.writeNumberField("defaultTtl", defaultTtl());
        jsonWriter.writeJsonField("uniqueKeyPolicy", uniqueKeyPolicy());
        jsonWriter.writeJsonField("conflictResolutionPolicy", conflictResolutionPolicy());
        jsonWriter.writeNumberField("analyticalStorageTtl", analyticalStorageTtl());
        jsonWriter.writeJsonField("restoreParameters", restoreParameters());
        jsonWriter.writeStringField("createMode", createMode() == null ? null : createMode().toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GremlinGraphGetPropertiesResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GremlinGraphGetPropertiesResource if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GremlinGraphGetPropertiesResource.
     */
    public static GremlinGraphGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GremlinGraphGetPropertiesResource deserializedGremlinGraphGetPropertiesResource
                = new GremlinGraphGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.withId(reader.getString());
                } else if ("indexingPolicy".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.withIndexingPolicy(IndexingPolicy.fromJson(reader));
                } else if ("partitionKey".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource
                        .withPartitionKey(ContainerPartitionKey.fromJson(reader));
                } else if ("defaultTtl".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource
                        .withDefaultTtl(reader.getNullable(JsonReader::getInt));
                } else if ("uniqueKeyPolicy".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.withUniqueKeyPolicy(UniqueKeyPolicy.fromJson(reader));
                } else if ("conflictResolutionPolicy".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource
                        .withConflictResolutionPolicy(ConflictResolutionPolicy.fromJson(reader));
                } else if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource
                        .withAnalyticalStorageTtl(reader.getNullable(JsonReader::getLong));
                } else if ("restoreParameters".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource
                        .withRestoreParameters(ResourceRestoreParameters.fromJson(reader));
                } else if ("createMode".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource
                        .withCreateMode(CreateMode.fromString(reader.getString()));
                } else if ("_rid".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.rid = reader.getString();
                } else if ("_ts".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.ts = reader.getNullable(JsonReader::getFloat);
                } else if ("_etag".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGremlinGraphGetPropertiesResource;
        });
    }
}
