// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the full text path specification.
 */
@Fluent
public final class FullTextPath implements JsonSerializable<FullTextPath> {
    /*
     * The path to the full text field in the document.
     */
    private String path;

    /*
     * The language of the full text field in the document.
     */
    private String language;

    /**
     * Creates an instance of FullTextPath class.
     */
    public FullTextPath() {
    }

    /**
     * Get the path property: The path to the full text field in the document.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: The path to the full text field in the document.
     * 
     * @param path the path value to set.
     * @return the FullTextPath object itself.
     */
    public FullTextPath withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the language property: The language of the full text field in the document.
     * 
     * @return the language value.
     */
    public String language() {
        return this.language;
    }

    /**
     * Set the language property: The language of the full text field in the document.
     * 
     * @param language the language value to set.
     * @return the FullTextPath object itself.
     */
    public FullTextPath withLanguage(String language) {
        this.language = language;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (path() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property path in model FullTextPath"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FullTextPath.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("language", this.language);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FullTextPath from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FullTextPath if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FullTextPath.
     */
    public static FullTextPath fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FullTextPath deserializedFullTextPath = new FullTextPath();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("path".equals(fieldName)) {
                    deserializedFullTextPath.path = reader.getString();
                } else if ("language".equals(fieldName)) {
                    deserializedFullTextPath.language = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFullTextPath;
        });
    }
}
