// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the full text index path.
 */
@Fluent
public final class FullTextIndexPath implements JsonSerializable<FullTextIndexPath> {
    /*
     * The path to the full text field in the document.
     */
    private String path;

    /**
     * Creates an instance of FullTextIndexPath class.
     */
    public FullTextIndexPath() {
    }

    /**
     * Get the path property: The path to the full text field in the document.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: The path to the full text field in the document.
     * 
     * @param path the path value to set.
     * @return the FullTextIndexPath object itself.
     */
    public FullTextIndexPath withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (path() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property path in model FullTextIndexPath"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FullTextIndexPath.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FullTextIndexPath from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FullTextIndexPath if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FullTextIndexPath.
     */
    public static FullTextIndexPath fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FullTextIndexPath deserializedFullTextIndexPath = new FullTextIndexPath();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("path".equals(fieldName)) {
                    deserializedFullTextIndexPath.path = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFullTextIndexPath;
        });
    }
}
