// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.FleetspaceProperties;
import java.io.IOException;
import java.util.List;

/**
 * Represents a fleetspace resource for updates.
 */
@Fluent
public final class FleetspaceUpdate implements JsonSerializable<FleetspaceUpdate> {
    /*
     * Properties of the fleetspace.
     */
    private FleetspaceProperties innerProperties;

    /**
     * Creates an instance of FleetspaceUpdate class.
     */
    public FleetspaceUpdate() {
    }

    /**
     * Get the innerProperties property: Properties of the fleetspace.
     * 
     * @return the innerProperties value.
     */
    private FleetspaceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the provisioningState property: A provisioning state of the Fleetspace.
     * 
     * @return the provisioningState value.
     */
    public Status provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Set the provisioningState property: A provisioning state of the Fleetspace.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the FleetspaceUpdate object itself.
     */
    public FleetspaceUpdate withProvisioningState(Status provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    /**
     * Get the fleetspaceApiKind property: The kind of API this fleetspace belongs to. Acceptable values: 'NoSQL'.
     * 
     * @return the fleetspaceApiKind value.
     */
    public FleetspacePropertiesFleetspaceApiKind fleetspaceApiKind() {
        return this.innerProperties() == null ? null : this.innerProperties().fleetspaceApiKind();
    }

    /**
     * Set the fleetspaceApiKind property: The kind of API this fleetspace belongs to. Acceptable values: 'NoSQL'.
     * 
     * @param fleetspaceApiKind the fleetspaceApiKind value to set.
     * @return the FleetspaceUpdate object itself.
     */
    public FleetspaceUpdate withFleetspaceApiKind(FleetspacePropertiesFleetspaceApiKind fleetspaceApiKind) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceProperties();
        }
        this.innerProperties().withFleetspaceApiKind(fleetspaceApiKind);
        return this;
    }

    /**
     * Get the serviceTier property: Service Tier for the fleetspace. GeneralPurpose types refers to single write region
     * accounts that can be added to this fleetspace, whereas BusinessCritical refers to multi write region.
     * 
     * @return the serviceTier value.
     */
    public FleetspacePropertiesServiceTier serviceTier() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceTier();
    }

    /**
     * Set the serviceTier property: Service Tier for the fleetspace. GeneralPurpose types refers to single write region
     * accounts that can be added to this fleetspace, whereas BusinessCritical refers to multi write region.
     * 
     * @param serviceTier the serviceTier value to set.
     * @return the FleetspaceUpdate object itself.
     */
    public FleetspaceUpdate withServiceTier(FleetspacePropertiesServiceTier serviceTier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceProperties();
        }
        this.innerProperties().withServiceTier(serviceTier);
        return this;
    }

    /**
     * Get the dataRegions property: List of data regions assigned to the fleetspace. Eg [westus2].
     * 
     * @return the dataRegions value.
     */
    public List<String> dataRegions() {
        return this.innerProperties() == null ? null : this.innerProperties().dataRegions();
    }

    /**
     * Set the dataRegions property: List of data regions assigned to the fleetspace. Eg [westus2].
     * 
     * @param dataRegions the dataRegions value to set.
     * @return the FleetspaceUpdate object itself.
     */
    public FleetspaceUpdate withDataRegions(List<String> dataRegions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceProperties();
        }
        this.innerProperties().withDataRegions(dataRegions);
        return this;
    }

    /**
     * Get the throughputPoolConfiguration property: Configuration for throughput pool in the fleetspace.
     * 
     * @return the throughputPoolConfiguration value.
     */
    public FleetspacePropertiesThroughputPoolConfiguration throughputPoolConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().throughputPoolConfiguration();
    }

    /**
     * Set the throughputPoolConfiguration property: Configuration for throughput pool in the fleetspace.
     * 
     * @param throughputPoolConfiguration the throughputPoolConfiguration value to set.
     * @return the FleetspaceUpdate object itself.
     */
    public FleetspaceUpdate
        withThroughputPoolConfiguration(FleetspacePropertiesThroughputPoolConfiguration throughputPoolConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceProperties();
        }
        this.innerProperties().withThroughputPoolConfiguration(throughputPoolConfiguration);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FleetspaceUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FleetspaceUpdate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FleetspaceUpdate.
     */
    public static FleetspaceUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FleetspaceUpdate deserializedFleetspaceUpdate = new FleetspaceUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedFleetspaceUpdate.innerProperties = FleetspaceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFleetspaceUpdate;
        });
    }
}
