// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration for throughput pool in the fleetspace.
 */
@Fluent
public final class FleetspacePropertiesThroughputPoolConfiguration
    implements JsonSerializable<FleetspacePropertiesThroughputPoolConfiguration> {
    /*
     * Minimum throughput for the pool.
     */
    private Integer minThroughput;

    /*
     * Maximum throughput for the pool.
     */
    private Integer maxThroughput;

    /**
     * Creates an instance of FleetspacePropertiesThroughputPoolConfiguration class.
     */
    public FleetspacePropertiesThroughputPoolConfiguration() {
    }

    /**
     * Get the minThroughput property: Minimum throughput for the pool.
     * 
     * @return the minThroughput value.
     */
    public Integer minThroughput() {
        return this.minThroughput;
    }

    /**
     * Set the minThroughput property: Minimum throughput for the pool.
     * 
     * @param minThroughput the minThroughput value to set.
     * @return the FleetspacePropertiesThroughputPoolConfiguration object itself.
     */
    public FleetspacePropertiesThroughputPoolConfiguration withMinThroughput(Integer minThroughput) {
        this.minThroughput = minThroughput;
        return this;
    }

    /**
     * Get the maxThroughput property: Maximum throughput for the pool.
     * 
     * @return the maxThroughput value.
     */
    public Integer maxThroughput() {
        return this.maxThroughput;
    }

    /**
     * Set the maxThroughput property: Maximum throughput for the pool.
     * 
     * @param maxThroughput the maxThroughput value to set.
     * @return the FleetspacePropertiesThroughputPoolConfiguration object itself.
     */
    public FleetspacePropertiesThroughputPoolConfiguration withMaxThroughput(Integer maxThroughput) {
        this.maxThroughput = maxThroughput;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("minThroughput", this.minThroughput);
        jsonWriter.writeNumberField("maxThroughput", this.maxThroughput);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FleetspacePropertiesThroughputPoolConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FleetspacePropertiesThroughputPoolConfiguration if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FleetspacePropertiesThroughputPoolConfiguration.
     */
    public static FleetspacePropertiesThroughputPoolConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FleetspacePropertiesThroughputPoolConfiguration deserializedFleetspacePropertiesThroughputPoolConfiguration
                = new FleetspacePropertiesThroughputPoolConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("minThroughput".equals(fieldName)) {
                    deserializedFleetspacePropertiesThroughputPoolConfiguration.minThroughput
                        = reader.getNullable(JsonReader::getInt);
                } else if ("maxThroughput".equals(fieldName)) {
                    deserializedFleetspacePropertiesThroughputPoolConfiguration.maxThroughput
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFleetspacePropertiesThroughputPoolConfiguration;
        });
    }
}
