// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Service Tier for the fleetspace. GeneralPurpose types refers to single write region accounts that can be added to
 * this fleetspace, whereas BusinessCritical refers to multi write region.
 */
public final class FleetspacePropertiesServiceTier extends ExpandableStringEnum<FleetspacePropertiesServiceTier> {
    /**
     * Static value GeneralPurpose for FleetspacePropertiesServiceTier.
     */
    public static final FleetspacePropertiesServiceTier GENERAL_PURPOSE = fromString("GeneralPurpose");

    /**
     * Static value BusinessCritical for FleetspacePropertiesServiceTier.
     */
    public static final FleetspacePropertiesServiceTier BUSINESS_CRITICAL = fromString("BusinessCritical");

    /**
     * Creates a new instance of FleetspacePropertiesServiceTier value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public FleetspacePropertiesServiceTier() {
    }

    /**
     * Creates or finds a FleetspacePropertiesServiceTier from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding FleetspacePropertiesServiceTier.
     */
    public static FleetspacePropertiesServiceTier fromString(String name) {
        return fromString(name, FleetspacePropertiesServiceTier.class);
    }

    /**
     * Gets known FleetspacePropertiesServiceTier values.
     * 
     * @return known FleetspacePropertiesServiceTier values.
     */
    public static Collection<FleetspacePropertiesServiceTier> values() {
        return values(FleetspacePropertiesServiceTier.class);
    }
}
