// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration for fleetspace Account in the fleetspace.
 */
@Fluent
public final class FleetspaceAccountPropertiesGlobalDatabaseAccountProperties
    implements JsonSerializable<FleetspaceAccountPropertiesGlobalDatabaseAccountProperties> {
    /*
     * The resource identifier of global database account in the Fleetspace Account.
     */
    private String resourceId;

    /*
     * The location of global database account in the Fleetspace Account.
     */
    private String armLocation;

    /**
     * Creates an instance of FleetspaceAccountPropertiesGlobalDatabaseAccountProperties class.
     */
    public FleetspaceAccountPropertiesGlobalDatabaseAccountProperties() {
    }

    /**
     * Get the resourceId property: The resource identifier of global database account in the Fleetspace Account.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The resource identifier of global database account in the Fleetspace Account.
     * 
     * @param resourceId the resourceId value to set.
     * @return the FleetspaceAccountPropertiesGlobalDatabaseAccountProperties object itself.
     */
    public FleetspaceAccountPropertiesGlobalDatabaseAccountProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the armLocation property: The location of global database account in the Fleetspace Account.
     * 
     * @return the armLocation value.
     */
    public String armLocation() {
        return this.armLocation;
    }

    /**
     * Set the armLocation property: The location of global database account in the Fleetspace Account.
     * 
     * @param armLocation the armLocation value to set.
     * @return the FleetspaceAccountPropertiesGlobalDatabaseAccountProperties object itself.
     */
    public FleetspaceAccountPropertiesGlobalDatabaseAccountProperties withArmLocation(String armLocation) {
        this.armLocation = armLocation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("armLocation", this.armLocation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FleetspaceAccountPropertiesGlobalDatabaseAccountProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FleetspaceAccountPropertiesGlobalDatabaseAccountProperties if the JsonReader was pointing
     * to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * FleetspaceAccountPropertiesGlobalDatabaseAccountProperties.
     */
    public static FleetspaceAccountPropertiesGlobalDatabaseAccountProperties fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            FleetspaceAccountPropertiesGlobalDatabaseAccountProperties deserializedFleetspaceAccountPropertiesGlobalDatabaseAccountProperties
                = new FleetspaceAccountPropertiesGlobalDatabaseAccountProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedFleetspaceAccountPropertiesGlobalDatabaseAccountProperties.resourceId
                        = reader.getString();
                } else if ("armLocation".equals(fieldName)) {
                    deserializedFleetspaceAccountPropertiesGlobalDatabaseAccountProperties.armLocation
                        = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFleetspaceAccountPropertiesGlobalDatabaseAccountProperties;
        });
    }
}
