// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.FleetResourceProperties;
import java.io.IOException;

/**
 * Represents a fleet resource for updates.
 */
@Fluent
public final class FleetResourceUpdate implements JsonSerializable<FleetResourceUpdate> {
    /*
     * Properties to update Azure Cosmos DB fleet resource.
     */
    private FleetResourceProperties innerProperties;

    /**
     * Creates an instance of FleetResourceUpdate class.
     */
    public FleetResourceUpdate() {
    }

    /**
     * Get the innerProperties property: Properties to update Azure Cosmos DB fleet resource.
     * 
     * @return the innerProperties value.
     */
    private FleetResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the provisioningState property: A provisioning state of the Fleet.
     * 
     * @return the provisioningState value.
     */
    public Status provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Set the provisioningState property: A provisioning state of the Fleet.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the FleetResourceUpdate object itself.
     */
    public FleetResourceUpdate withProvisioningState(Status provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetResourceProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FleetResourceUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FleetResourceUpdate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FleetResourceUpdate.
     */
    public static FleetResourceUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FleetResourceUpdate deserializedFleetResourceUpdate = new FleetResourceUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedFleetResourceUpdate.innerProperties = FleetResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFleetResourceUpdate;
        });
    }
}
