// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.FleetResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * The response of the List operation that contains the fleets and their properties.
 */
@Immutable
public final class FleetListResult implements JsonSerializable<FleetListResult> {
    /*
     * List of fleets and their properties.
     */
    private List<FleetResourceInner> value;

    /*
     * The link used to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of FleetListResult class.
     */
    public FleetListResult() {
    }

    /**
     * Get the value property: List of fleets and their properties.
     * 
     * @return the value value.
     */
    public List<FleetResourceInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: The link used to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FleetListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FleetListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FleetListResult.
     */
    public static FleetListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FleetListResult deserializedFleetListResult = new FleetListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<FleetResourceInner> value = reader.readArray(reader1 -> FleetResourceInner.fromJson(reader1));
                    deserializedFleetListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedFleetListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFleetListResult;
        });
    }
}
