// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters to regenerate the keys within the database account.
 */
@Fluent
public final class DatabaseAccountRegenerateKeyParameters
    implements JsonSerializable<DatabaseAccountRegenerateKeyParameters> {
    /*
     * The access key to regenerate.
     */
    private KeyKind keyKind;

    /**
     * Creates an instance of DatabaseAccountRegenerateKeyParameters class.
     */
    public DatabaseAccountRegenerateKeyParameters() {
    }

    /**
     * Get the keyKind property: The access key to regenerate.
     * 
     * @return the keyKind value.
     */
    public KeyKind keyKind() {
        return this.keyKind;
    }

    /**
     * Set the keyKind property: The access key to regenerate.
     * 
     * @param keyKind the keyKind value to set.
     * @return the DatabaseAccountRegenerateKeyParameters object itself.
     */
    public DatabaseAccountRegenerateKeyParameters withKeyKind(KeyKind keyKind) {
        this.keyKind = keyKind;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyKind() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property keyKind in model DatabaseAccountRegenerateKeyParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DatabaseAccountRegenerateKeyParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyKind", this.keyKind == null ? null : this.keyKind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseAccountRegenerateKeyParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseAccountRegenerateKeyParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DatabaseAccountRegenerateKeyParameters.
     */
    public static DatabaseAccountRegenerateKeyParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseAccountRegenerateKeyParameters deserializedDatabaseAccountRegenerateKeyParameters
                = new DatabaseAccountRegenerateKeyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyKind".equals(fieldName)) {
                    deserializedDatabaseAccountRegenerateKeyParameters.keyKind = KeyKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseAccountRegenerateKeyParameters;
        });
    }
}
