// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The conflict resolution policy for the container.
 */
@Fluent
public final class ConflictResolutionPolicy implements JsonSerializable<ConflictResolutionPolicy> {
    /*
     * Indicates the conflict resolution mode.
     */
    private ConflictResolutionMode mode;

    /*
     * The conflict resolution path in the case of LastWriterWins mode.
     */
    private String conflictResolutionPath;

    /*
     * The procedure to resolve conflicts in the case of custom mode.
     */
    private String conflictResolutionProcedure;

    /**
     * Creates an instance of ConflictResolutionPolicy class.
     */
    public ConflictResolutionPolicy() {
    }

    /**
     * Get the mode property: Indicates the conflict resolution mode.
     * 
     * @return the mode value.
     */
    public ConflictResolutionMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Indicates the conflict resolution mode.
     * 
     * @param mode the mode value to set.
     * @return the ConflictResolutionPolicy object itself.
     */
    public ConflictResolutionPolicy withMode(ConflictResolutionMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the conflictResolutionPath property: The conflict resolution path in the case of LastWriterWins mode.
     * 
     * @return the conflictResolutionPath value.
     */
    public String conflictResolutionPath() {
        return this.conflictResolutionPath;
    }

    /**
     * Set the conflictResolutionPath property: The conflict resolution path in the case of LastWriterWins mode.
     * 
     * @param conflictResolutionPath the conflictResolutionPath value to set.
     * @return the ConflictResolutionPolicy object itself.
     */
    public ConflictResolutionPolicy withConflictResolutionPath(String conflictResolutionPath) {
        this.conflictResolutionPath = conflictResolutionPath;
        return this;
    }

    /**
     * Get the conflictResolutionProcedure property: The procedure to resolve conflicts in the case of custom mode.
     * 
     * @return the conflictResolutionProcedure value.
     */
    public String conflictResolutionProcedure() {
        return this.conflictResolutionProcedure;
    }

    /**
     * Set the conflictResolutionProcedure property: The procedure to resolve conflicts in the case of custom mode.
     * 
     * @param conflictResolutionProcedure the conflictResolutionProcedure value to set.
     * @return the ConflictResolutionPolicy object itself.
     */
    public ConflictResolutionPolicy withConflictResolutionProcedure(String conflictResolutionProcedure) {
        this.conflictResolutionProcedure = conflictResolutionProcedure;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeStringField("conflictResolutionPath", this.conflictResolutionPath);
        jsonWriter.writeStringField("conflictResolutionProcedure", this.conflictResolutionProcedure);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConflictResolutionPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConflictResolutionPolicy if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConflictResolutionPolicy.
     */
    public static ConflictResolutionPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConflictResolutionPolicy deserializedConflictResolutionPolicy = new ConflictResolutionPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mode".equals(fieldName)) {
                    deserializedConflictResolutionPolicy.mode = ConflictResolutionMode.fromString(reader.getString());
                } else if ("conflictResolutionPath".equals(fieldName)) {
                    deserializedConflictResolutionPolicy.conflictResolutionPath = reader.getString();
                } else if ("conflictResolutionProcedure".equals(fieldName)) {
                    deserializedConflictResolutionPolicy.conflictResolutionProcedure = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConflictResolutionPolicy;
        });
    }
}
