// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Cosmos DB Cassandra table schema.
 */
@Fluent
public final class CassandraSchema implements JsonSerializable<CassandraSchema> {
    /*
     * List of Cassandra table columns.
     */
    private List<Column> columns;

    /*
     * List of partition key.
     */
    private List<CassandraPartitionKey> partitionKeys;

    /*
     * List of cluster key.
     */
    private List<ClusterKey> clusterKeys;

    /**
     * Creates an instance of CassandraSchema class.
     */
    public CassandraSchema() {
    }

    /**
     * Get the columns property: List of Cassandra table columns.
     * 
     * @return the columns value.
     */
    public List<Column> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: List of Cassandra table columns.
     * 
     * @param columns the columns value to set.
     * @return the CassandraSchema object itself.
     */
    public CassandraSchema withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Get the partitionKeys property: List of partition key.
     * 
     * @return the partitionKeys value.
     */
    public List<CassandraPartitionKey> partitionKeys() {
        return this.partitionKeys;
    }

    /**
     * Set the partitionKeys property: List of partition key.
     * 
     * @param partitionKeys the partitionKeys value to set.
     * @return the CassandraSchema object itself.
     */
    public CassandraSchema withPartitionKeys(List<CassandraPartitionKey> partitionKeys) {
        this.partitionKeys = partitionKeys;
        return this;
    }

    /**
     * Get the clusterKeys property: List of cluster key.
     * 
     * @return the clusterKeys value.
     */
    public List<ClusterKey> clusterKeys() {
        return this.clusterKeys;
    }

    /**
     * Set the clusterKeys property: List of cluster key.
     * 
     * @param clusterKeys the clusterKeys value to set.
     * @return the CassandraSchema object itself.
     */
    public CassandraSchema withClusterKeys(List<ClusterKey> clusterKeys) {
        this.clusterKeys = clusterKeys;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (columns() != null) {
            columns().forEach(e -> e.validate());
        }
        if (partitionKeys() != null) {
            partitionKeys().forEach(e -> e.validate());
        }
        if (clusterKeys() != null) {
            clusterKeys().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("partitionKeys", this.partitionKeys, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("clusterKeys", this.clusterKeys, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CassandraSchema from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CassandraSchema if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CassandraSchema.
     */
    public static CassandraSchema fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CassandraSchema deserializedCassandraSchema = new CassandraSchema();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("columns".equals(fieldName)) {
                    List<Column> columns = reader.readArray(reader1 -> Column.fromJson(reader1));
                    deserializedCassandraSchema.columns = columns;
                } else if ("partitionKeys".equals(fieldName)) {
                    List<CassandraPartitionKey> partitionKeys
                        = reader.readArray(reader1 -> CassandraPartitionKey.fromJson(reader1));
                    deserializedCassandraSchema.partitionKeys = partitionKeys;
                } else if ("clusterKeys".equals(fieldName)) {
                    List<ClusterKey> clusterKeys = reader.readArray(reader1 -> ClusterKey.fromJson(reader1));
                    deserializedCassandraSchema.clusterKeys = clusterKeys;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCassandraSchema;
        });
    }
}
