// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The CassandraClusterPublicStatusDataCentersItem model.
 */
@Fluent
public final class CassandraClusterPublicStatusDataCentersItem
    implements JsonSerializable<CassandraClusterPublicStatusDataCentersItem> {
    /*
     * The name of this Datacenter.
     */
    private String name;

    /*
     * A list of all seed nodes in the cluster, managed and unmanaged.
     */
    private List<String> seedNodes;

    /*
     * The nodes property.
     */
    private List<CassandraClusterPublicStatusDataCentersItemNode> nodes;

    /**
     * Creates an instance of CassandraClusterPublicStatusDataCentersItem class.
     */
    public CassandraClusterPublicStatusDataCentersItem() {
    }

    /**
     * Get the name property: The name of this Datacenter.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of this Datacenter.
     * 
     * @param name the name value to set.
     * @return the CassandraClusterPublicStatusDataCentersItem object itself.
     */
    public CassandraClusterPublicStatusDataCentersItem withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the seedNodes property: A list of all seed nodes in the cluster, managed and unmanaged.
     * 
     * @return the seedNodes value.
     */
    public List<String> seedNodes() {
        return this.seedNodes;
    }

    /**
     * Set the seedNodes property: A list of all seed nodes in the cluster, managed and unmanaged.
     * 
     * @param seedNodes the seedNodes value to set.
     * @return the CassandraClusterPublicStatusDataCentersItem object itself.
     */
    public CassandraClusterPublicStatusDataCentersItem withSeedNodes(List<String> seedNodes) {
        this.seedNodes = seedNodes;
        return this;
    }

    /**
     * Get the nodes property: The nodes property.
     * 
     * @return the nodes value.
     */
    public List<CassandraClusterPublicStatusDataCentersItemNode> nodes() {
        return this.nodes;
    }

    /**
     * Set the nodes property: The nodes property.
     * 
     * @param nodes the nodes value to set.
     * @return the CassandraClusterPublicStatusDataCentersItem object itself.
     */
    public CassandraClusterPublicStatusDataCentersItem
        withNodes(List<CassandraClusterPublicStatusDataCentersItemNode> nodes) {
        this.nodes = nodes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (nodes() != null) {
            nodes().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("seedNodes", this.seedNodes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("nodes", this.nodes, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CassandraClusterPublicStatusDataCentersItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CassandraClusterPublicStatusDataCentersItem if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CassandraClusterPublicStatusDataCentersItem.
     */
    public static CassandraClusterPublicStatusDataCentersItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CassandraClusterPublicStatusDataCentersItem deserializedCassandraClusterPublicStatusDataCentersItem
                = new CassandraClusterPublicStatusDataCentersItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItem.name = reader.getString();
                } else if ("seedNodes".equals(fieldName)) {
                    List<String> seedNodes = reader.readArray(reader1 -> reader1.getString());
                    deserializedCassandraClusterPublicStatusDataCentersItem.seedNodes = seedNodes;
                } else if ("nodes".equals(fieldName)) {
                    List<CassandraClusterPublicStatusDataCentersItemNode> nodes = reader
                        .readArray(reader1 -> CassandraClusterPublicStatusDataCentersItemNode.fromJson(reader1));
                    deserializedCassandraClusterPublicStatusDataCentersItem.nodes = nodes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCassandraClusterPublicStatusDataCentersItem;
        });
    }
}
