// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.FleetspacesClient;
import com.azure.resourcemanager.cosmos.fluent.models.FleetspaceResourceInner;
import com.azure.resourcemanager.cosmos.models.FleetspaceListResult;
import com.azure.resourcemanager.cosmos.models.FleetspaceUpdate;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in FleetspacesClient.
 */
public final class FleetspacesClientImpl implements FleetspacesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final FleetspacesService service;

    /**
     * The service client containing this operation class.
     */
    private final CosmosDBManagementClientImpl client;

    /**
     * Initializes an instance of FleetspacesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    FleetspacesClientImpl(CosmosDBManagementClientImpl client) {
        this.service
            = RestProxy.create(FleetspacesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CosmosDBManagementClientFleetspaces to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CosmosDBManagementClientFleetspaces")
    public interface FleetspacesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FleetspaceListResult>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("fleetName") String fleetName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FleetspaceResourceInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("fleetName") String fleetName,
            @PathParam("fleetspaceName") String fleetspaceName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> create(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("fleetName") String fleetName,
            @PathParam("fleetspaceName") String fleetspaceName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") FleetspaceResourceInner body, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("fleetName") String fleetName,
            @PathParam("fleetspaceName") String fleetspaceName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") FleetspaceUpdate body, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("fleetName") String fleetName,
            @PathParam("fleetspaceName") String fleetspaceName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FleetspaceListResult>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists all the fleetspaces under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleetspaces and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceResourceInner>> listSinglePageAsync(String resourceGroupName,
        String fleetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, fleetName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<FleetspaceResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all the fleetspaces under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleetspaces and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceResourceInner>> listSinglePageAsync(String resourceGroupName, String fleetName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all the fleetspaces under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleetspaces and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<FleetspaceResourceInner> listAsync(String resourceGroupName, String fleetName) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, fleetName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all the fleetspaces under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleetspaces and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<FleetspaceResourceInner> listAsync(String resourceGroupName, String fleetName, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, fleetName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all the fleetspaces under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleetspaces and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<FleetspaceResourceInner> list(String resourceGroupName, String fleetName) {
        return new PagedIterable<>(listAsync(resourceGroupName, fleetName));
    }

    /**
     * Lists all the fleetspaces under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleetspaces and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<FleetspaceResourceInner> list(String resourceGroupName, String fleetName, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, fleetName, context));
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<FleetspaceResourceInner>> getWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<FleetspaceResourceInner>> getWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName,
            fleetspaceName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FleetspaceResourceInner> getAsync(String resourceGroupName, String fleetName, String fleetspaceName) {
        return getWithResponseAsync(resourceGroupName, fleetName, fleetspaceName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<FleetspaceResourceInner> getWithResponse(String resourceGroupName, String fleetName,
        String fleetspaceName, Context context) {
        return getWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, context).block();
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FleetspaceResourceInner get(String resourceGroupName, String fleetName, String fleetspaceName) {
        return getWithResponse(resourceGroupName, fleetName, fleetspaceName, Context.NONE).getValue();
    }

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, FleetspaceResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.create(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, FleetspaceResourceInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName,
            fleetspaceName, this.client.getApiVersion(), body, accept, context);
    }

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginCreateAsync(
        String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, body);
        return this.client.<FleetspaceResourceInner, FleetspaceResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), FleetspaceResourceInner.class, FleetspaceResourceInner.class,
            this.client.getContext());
    }

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginCreateAsync(
        String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, body, context);
        return this.client.<FleetspaceResourceInner, FleetspaceResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), FleetspaceResourceInner.class, FleetspaceResourceInner.class, context);
    }

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner>
        beginCreate(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body) {
        return this.beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, body).getSyncPoller();
    }

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginCreate(
        String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceResourceInner body,
        Context context) {
        return this.beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, body, context).getSyncPoller();
    }

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FleetspaceResourceInner> createAsync(String resourceGroupName, String fleetName, String fleetspaceName,
        FleetspaceResourceInner body) {
        return beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, body).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<FleetspaceResourceInner> createAsync(String resourceGroupName, String fleetName, String fleetspaceName,
        FleetspaceResourceInner body, Context context) {
        return beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, body, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FleetspaceResourceInner create(String resourceGroupName, String fleetName, String fleetspaceName,
        FleetspaceResourceInner body) {
        return createAsync(resourceGroupName, fleetName, fleetspaceName, body).block();
    }

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FleetspaceResourceInner create(String resourceGroupName, String fleetName, String fleetspaceName,
        FleetspaceResourceInner body, Context context) {
        return createAsync(resourceGroupName, fleetName, fleetspaceName, body, context).block();
    }

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, FleetspaceUpdate body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, FleetspaceUpdate body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName,
            fleetspaceName, this.client.getApiVersion(), body, accept, context);
    }

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner>
        beginUpdateAsync(String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceUpdate body) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, body);
        return this.client.<FleetspaceResourceInner, FleetspaceResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), FleetspaceResourceInner.class, FleetspaceResourceInner.class,
            this.client.getContext());
    }

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner>
        beginUpdateAsync(String resourceGroupName, String fleetName, String fleetspaceName) {
        final FleetspaceUpdate body = null;
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, body);
        return this.client.<FleetspaceResourceInner, FleetspaceResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), FleetspaceResourceInner.class, FleetspaceResourceInner.class,
            this.client.getContext());
    }

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginUpdateAsync(
        String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceUpdate body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, body, context);
        return this.client.<FleetspaceResourceInner, FleetspaceResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), FleetspaceResourceInner.class, FleetspaceResourceInner.class, context);
    }

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner>
        beginUpdate(String resourceGroupName, String fleetName, String fleetspaceName) {
        final FleetspaceUpdate body = null;
        return this.beginUpdateAsync(resourceGroupName, fleetName, fleetspaceName, body).getSyncPoller();
    }

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginUpdate(
        String resourceGroupName, String fleetName, String fleetspaceName, FleetspaceUpdate body, Context context) {
        return this.beginUpdateAsync(resourceGroupName, fleetName, fleetspaceName, body, context).getSyncPoller();
    }

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FleetspaceResourceInner> updateAsync(String resourceGroupName, String fleetName, String fleetspaceName,
        FleetspaceUpdate body) {
        return beginUpdateAsync(resourceGroupName, fleetName, fleetspaceName, body).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FleetspaceResourceInner> updateAsync(String resourceGroupName, String fleetName,
        String fleetspaceName) {
        final FleetspaceUpdate body = null;
        return beginUpdateAsync(resourceGroupName, fleetName, fleetspaceName, body).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<FleetspaceResourceInner> updateAsync(String resourceGroupName, String fleetName, String fleetspaceName,
        FleetspaceUpdate body, Context context) {
        return beginUpdateAsync(resourceGroupName, fleetName, fleetspaceName, body, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FleetspaceResourceInner update(String resourceGroupName, String fleetName, String fleetspaceName) {
        final FleetspaceUpdate body = null;
        return updateAsync(resourceGroupName, fleetName, fleetspaceName, body).block();
    }

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FleetspaceResourceInner update(String resourceGroupName, String fleetName, String fleetspaceName,
        FleetspaceUpdate body, Context context) {
        return updateAsync(resourceGroupName, fleetName, fleetspaceName, body, context).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName,
            fleetspaceName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String fleetName,
        String fleetspaceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, fleetName, fleetspaceName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName,
        String fleetspaceName) {
        return this.beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName,
        String fleetspaceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName, context).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String fleetName, String fleetspaceName) {
        return beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String fleetName, String fleetspaceName, Context context) {
        return beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String fleetName, String fleetspaceName) {
        deleteAsync(resourceGroupName, fleetName, fleetspaceName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String fleetName, String fleetspaceName, Context context) {
        deleteAsync(resourceGroupName, fleetName, fleetspaceName, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleetspaces and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<FleetspaceResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleetspaces and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
