// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.FleetspaceAccountsClient;
import com.azure.resourcemanager.cosmos.fluent.models.FleetspaceAccountResourceInner;
import com.azure.resourcemanager.cosmos.models.FleetspaceAccountListResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in FleetspaceAccountsClient.
 */
public final class FleetspaceAccountsClientImpl implements FleetspaceAccountsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final FleetspaceAccountsService service;

    /**
     * The service client containing this operation class.
     */
    private final CosmosDBManagementClientImpl client;

    /**
     * Initializes an instance of FleetspaceAccountsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    FleetspaceAccountsClientImpl(CosmosDBManagementClientImpl client) {
        this.service = RestProxy.create(FleetspaceAccountsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CosmosDBManagementClientFleetspaceAccounts to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CosmosDBManagementClientFleetspaceAccounts")
    public interface FleetspaceAccountsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}/fleetspaceAccounts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FleetspaceAccountListResult>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("fleetName") String fleetName,
            @PathParam("fleetspaceName") String fleetspaceName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}/fleetspaceAccounts/{fleetspaceAccountName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FleetspaceAccountResourceInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("fleetName") String fleetName,
            @PathParam("fleetspaceName") String fleetspaceName,
            @PathParam("fleetspaceAccountName") String fleetspaceAccountName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}/fleetspaceAccounts/{fleetspaceAccountName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> create(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("fleetName") String fleetName,
            @PathParam("fleetspaceName") String fleetspaceName,
            @PathParam("fleetspaceAccountName") String fleetspaceAccountName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") FleetspaceAccountResourceInner body, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/fleets/{fleetName}/fleetspaces/{fleetspaceName}/fleetspaceAccounts/{fleetspaceAccountName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("fleetName") String fleetName,
            @PathParam("fleetspaceName") String fleetspaceName,
            @PathParam("fleetspaceAccountName") String fleetspaceAccountName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FleetspaceAccountListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists all the fleetspaces accounts under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the global database accounts and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceAccountResourceInner>> listSinglePageAsync(String resourceGroupName,
        String fleetName, String fleetspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, fleetName, fleetspaceName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<FleetspaceAccountResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all the fleetspaces accounts under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the global database accounts and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceAccountResourceInner>> listSinglePageAsync(String resourceGroupName,
        String fleetName, String fleetspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName,
                fleetspaceName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all the fleetspaces accounts under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the global database accounts and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<FleetspaceAccountResourceInner> listAsync(String resourceGroupName, String fleetName,
        String fleetspaceName) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, fleetName, fleetspaceName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all the fleetspaces accounts under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the global database accounts and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<FleetspaceAccountResourceInner> listAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, fleetName, fleetspaceName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all the fleetspaces accounts under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the global database accounts and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<FleetspaceAccountResourceInner> list(String resourceGroupName, String fleetName,
        String fleetspaceName) {
        return new PagedIterable<>(listAsync(resourceGroupName, fleetName, fleetspaceName));
    }

    /**
     * Lists all the fleetspaces accounts under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the global database accounts and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<FleetspaceAccountResourceInner> list(String resourceGroupName, String fleetName,
        String fleetspaceName, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, fleetName, fleetspaceName, context));
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<FleetspaceAccountResourceInner>> getWithResponseAsync(String resourceGroupName,
        String fleetName, String fleetspaceName, String fleetspaceAccountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (fleetspaceAccountName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter fleetspaceAccountName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    fleetName, fleetspaceName, fleetspaceAccountName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<FleetspaceAccountResourceInner>> getWithResponseAsync(String resourceGroupName,
        String fleetName, String fleetspaceName, String fleetspaceAccountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (fleetspaceAccountName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter fleetspaceAccountName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName,
            fleetspaceName, fleetspaceAccountName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FleetspaceAccountResourceInner> getAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName) {
        return getWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<FleetspaceAccountResourceInner> getWithResponse(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName, Context context) {
        return getWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, context)
            .block();
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FleetspaceAccountResourceInner get(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName) {
        return getWithResponse(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, Context.NONE)
            .getValue();
    }

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (fleetspaceAccountName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter fleetspaceAccountName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.create(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, this.client.getApiVersion(), body,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (fleetspaceAccountName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter fleetspaceAccountName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName,
            fleetspaceName, fleetspaceAccountName, this.client.getApiVersion(), body, accept, context);
    }

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<FleetspaceAccountResourceInner>, FleetspaceAccountResourceInner> beginCreateAsync(
        String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName,
        FleetspaceAccountResourceInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body);
        return this.client.<FleetspaceAccountResourceInner, FleetspaceAccountResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), FleetspaceAccountResourceInner.class, FleetspaceAccountResourceInner.class,
            this.client.getContext());
    }

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<FleetspaceAccountResourceInner>, FleetspaceAccountResourceInner> beginCreateAsync(
        String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName,
        FleetspaceAccountResourceInner body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createWithResponseAsync(resourceGroupName, fleetName, fleetspaceName,
            fleetspaceAccountName, body, context);
        return this.client.<FleetspaceAccountResourceInner, FleetspaceAccountResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), FleetspaceAccountResourceInner.class, FleetspaceAccountResourceInner.class,
            context);
    }

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FleetspaceAccountResourceInner>, FleetspaceAccountResourceInner> beginCreate(
        String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName,
        FleetspaceAccountResourceInner body) {
        return this.beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body)
            .getSyncPoller();
    }

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FleetspaceAccountResourceInner>, FleetspaceAccountResourceInner> beginCreate(
        String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName,
        FleetspaceAccountResourceInner body, Context context) {
        return this.beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body, context)
            .getSyncPoller();
    }

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FleetspaceAccountResourceInner> createAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body) {
        return beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<FleetspaceAccountResourceInner> createAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body, Context context) {
        return beginCreateAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FleetspaceAccountResourceInner create(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName, FleetspaceAccountResourceInner body) {
        return createAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body).block();
    }

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FleetspaceAccountResourceInner create(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName, FleetspaceAccountResourceInner body, Context context) {
        return createAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, body, context).block();
    }

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (fleetspaceAccountName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter fleetspaceAccountName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    fleetName, fleetspaceName, fleetspaceAccountName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (fleetspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter fleetspaceName is required and cannot be null."));
        }
        if (fleetspaceAccountName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter fleetspaceAccountName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, fleetName,
            fleetspaceName, fleetspaceAccountName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName) {
        return this.beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName)
            .getSyncPoller();
    }

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, context)
            .getSyncPoller();
    }

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName) {
        return beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName, Context context) {
        return beginDeleteAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName) {
        deleteAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName).block();
    }

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName,
        Context context) {
        deleteAsync(resourceGroupName, fleetName, fleetspaceName, fleetspaceAccountName, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the global database accounts and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceAccountResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<FleetspaceAccountResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the global database accounts and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FleetspaceAccountResourceInner>> listNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
