// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.MetricName;
import com.azure.resourcemanager.cosmos.models.PercentileMetricValue;
import com.azure.resourcemanager.cosmos.models.UnitType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Percentile Metric data.
 */
@Immutable
public final class PercentileMetricInner implements JsonSerializable<PercentileMetricInner> {
    /*
     * The start time for the metric (ISO-8601 format).
     */
    private OffsetDateTime startTime;

    /*
     * The end time for the metric (ISO-8601 format).
     */
    private OffsetDateTime endTime;

    /*
     * The time grain to be used to summarize the metric values.
     */
    private String timeGrain;

    /*
     * The unit of the metric.
     */
    private UnitType unit;

    /*
     * The name information for the metric.
     */
    private MetricName name;

    /*
     * The percentile metric values for the specified time window and timestep.
     */
    private List<PercentileMetricValue> metricValues;

    /**
     * Creates an instance of PercentileMetricInner class.
     */
    public PercentileMetricInner() {
    }

    /**
     * Get the startTime property: The start time for the metric (ISO-8601 format).
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: The end time for the metric (ISO-8601 format).
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Get the timeGrain property: The time grain to be used to summarize the metric values.
     * 
     * @return the timeGrain value.
     */
    public String timeGrain() {
        return this.timeGrain;
    }

    /**
     * Get the unit property: The unit of the metric.
     * 
     * @return the unit value.
     */
    public UnitType unit() {
        return this.unit;
    }

    /**
     * Get the name property: The name information for the metric.
     * 
     * @return the name value.
     */
    public MetricName name() {
        return this.name;
    }

    /**
     * Get the metricValues property: The percentile metric values for the specified time window and timestep.
     * 
     * @return the metricValues value.
     */
    public List<PercentileMetricValue> metricValues() {
        return this.metricValues;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() != null) {
            name().validate();
        }
        if (metricValues() != null) {
            metricValues().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PercentileMetricInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PercentileMetricInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PercentileMetricInner.
     */
    public static PercentileMetricInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PercentileMetricInner deserializedPercentileMetricInner = new PercentileMetricInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startTime".equals(fieldName)) {
                    deserializedPercentileMetricInner.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedPercentileMetricInner.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("timeGrain".equals(fieldName)) {
                    deserializedPercentileMetricInner.timeGrain = reader.getString();
                } else if ("unit".equals(fieldName)) {
                    deserializedPercentileMetricInner.unit = UnitType.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedPercentileMetricInner.name = MetricName.fromJson(reader);
                } else if ("metricValues".equals(fieldName)) {
                    List<PercentileMetricValue> metricValues
                        = reader.readArray(reader1 -> PercentileMetricValue.fromJson(reader1));
                    deserializedPercentileMetricInner.metricValues = metricValues;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPercentileMetricInner;
        });
    }
}
