// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.FleetspacePropertiesFleetspaceApiKind;
import com.azure.resourcemanager.cosmos.models.FleetspacePropertiesServiceTier;
import com.azure.resourcemanager.cosmos.models.FleetspacePropertiesThroughputPoolConfiguration;
import com.azure.resourcemanager.cosmos.models.Status;
import java.io.IOException;
import java.util.List;

/**
 * An Azure Cosmos DB Fleetspace.
 */
@Fluent
public final class FleetspaceResourceInner extends ProxyResource {
    /*
     * Properties to update Azure Cosmos DB Fleetspace.
     */
    private FleetspaceProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of FleetspaceResourceInner class.
     */
    public FleetspaceResourceInner() {
    }

    /**
     * Get the innerProperties property: Properties to update Azure Cosmos DB Fleetspace.
     * 
     * @return the innerProperties value.
     */
    private FleetspaceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: A provisioning state of the Fleetspace.
     * 
     * @return the provisioningState value.
     */
    public Status provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Set the provisioningState property: A provisioning state of the Fleetspace.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the FleetspaceResourceInner object itself.
     */
    public FleetspaceResourceInner withProvisioningState(Status provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    /**
     * Get the fleetspaceApiKind property: The kind of API this fleetspace belongs to. Acceptable values: 'NoSQL'.
     * 
     * @return the fleetspaceApiKind value.
     */
    public FleetspacePropertiesFleetspaceApiKind fleetspaceApiKind() {
        return this.innerProperties() == null ? null : this.innerProperties().fleetspaceApiKind();
    }

    /**
     * Set the fleetspaceApiKind property: The kind of API this fleetspace belongs to. Acceptable values: 'NoSQL'.
     * 
     * @param fleetspaceApiKind the fleetspaceApiKind value to set.
     * @return the FleetspaceResourceInner object itself.
     */
    public FleetspaceResourceInner withFleetspaceApiKind(FleetspacePropertiesFleetspaceApiKind fleetspaceApiKind) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceProperties();
        }
        this.innerProperties().withFleetspaceApiKind(fleetspaceApiKind);
        return this;
    }

    /**
     * Get the serviceTier property: Service Tier for the fleetspace. GeneralPurpose types refers to single write region
     * accounts that can be added to this fleetspace, whereas BusinessCritical refers to multi write region.
     * 
     * @return the serviceTier value.
     */
    public FleetspacePropertiesServiceTier serviceTier() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceTier();
    }

    /**
     * Set the serviceTier property: Service Tier for the fleetspace. GeneralPurpose types refers to single write region
     * accounts that can be added to this fleetspace, whereas BusinessCritical refers to multi write region.
     * 
     * @param serviceTier the serviceTier value to set.
     * @return the FleetspaceResourceInner object itself.
     */
    public FleetspaceResourceInner withServiceTier(FleetspacePropertiesServiceTier serviceTier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceProperties();
        }
        this.innerProperties().withServiceTier(serviceTier);
        return this;
    }

    /**
     * Get the dataRegions property: List of data regions assigned to the fleetspace. Eg [westus2].
     * 
     * @return the dataRegions value.
     */
    public List<String> dataRegions() {
        return this.innerProperties() == null ? null : this.innerProperties().dataRegions();
    }

    /**
     * Set the dataRegions property: List of data regions assigned to the fleetspace. Eg [westus2].
     * 
     * @param dataRegions the dataRegions value to set.
     * @return the FleetspaceResourceInner object itself.
     */
    public FleetspaceResourceInner withDataRegions(List<String> dataRegions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceProperties();
        }
        this.innerProperties().withDataRegions(dataRegions);
        return this;
    }

    /**
     * Get the throughputPoolConfiguration property: Configuration for throughput pool in the fleetspace.
     * 
     * @return the throughputPoolConfiguration value.
     */
    public FleetspacePropertiesThroughputPoolConfiguration throughputPoolConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().throughputPoolConfiguration();
    }

    /**
     * Set the throughputPoolConfiguration property: Configuration for throughput pool in the fleetspace.
     * 
     * @param throughputPoolConfiguration the throughputPoolConfiguration value to set.
     * @return the FleetspaceResourceInner object itself.
     */
    public FleetspaceResourceInner
        withThroughputPoolConfiguration(FleetspacePropertiesThroughputPoolConfiguration throughputPoolConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceProperties();
        }
        this.innerProperties().withThroughputPoolConfiguration(throughputPoolConfiguration);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FleetspaceResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FleetspaceResourceInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FleetspaceResourceInner.
     */
    public static FleetspaceResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FleetspaceResourceInner deserializedFleetspaceResourceInner = new FleetspaceResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedFleetspaceResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedFleetspaceResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedFleetspaceResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedFleetspaceResourceInner.innerProperties = FleetspaceProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedFleetspaceResourceInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFleetspaceResourceInner;
        });
    }
}
