// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.FleetspacePropertiesFleetspaceApiKind;
import com.azure.resourcemanager.cosmos.models.FleetspacePropertiesServiceTier;
import com.azure.resourcemanager.cosmos.models.FleetspacePropertiesThroughputPoolConfiguration;
import com.azure.resourcemanager.cosmos.models.Status;
import java.io.IOException;
import java.util.List;

/**
 * Properties to update Azure Cosmos DB Fleetspace.
 */
@Fluent
public final class FleetspaceProperties implements JsonSerializable<FleetspaceProperties> {
    /*
     * A provisioning state of the Fleetspace.
     */
    private Status provisioningState;

    /*
     * The kind of API this fleetspace belongs to. Acceptable values: 'NoSQL'
     */
    private FleetspacePropertiesFleetspaceApiKind fleetspaceApiKind;

    /*
     * Service Tier for the fleetspace. GeneralPurpose types refers to single write region accounts that can be added to
     * this fleetspace, whereas BusinessCritical refers to multi write region.
     */
    private FleetspacePropertiesServiceTier serviceTier;

    /*
     * List of data regions assigned to the fleetspace. Eg [westus2]
     */
    private List<String> dataRegions;

    /*
     * Configuration for throughput pool in the fleetspace.
     */
    private FleetspacePropertiesThroughputPoolConfiguration throughputPoolConfiguration;

    /**
     * Creates an instance of FleetspaceProperties class.
     */
    public FleetspaceProperties() {
    }

    /**
     * Get the provisioningState property: A provisioning state of the Fleetspace.
     * 
     * @return the provisioningState value.
     */
    public Status provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: A provisioning state of the Fleetspace.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the FleetspaceProperties object itself.
     */
    public FleetspaceProperties withProvisioningState(Status provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the fleetspaceApiKind property: The kind of API this fleetspace belongs to. Acceptable values: 'NoSQL'.
     * 
     * @return the fleetspaceApiKind value.
     */
    public FleetspacePropertiesFleetspaceApiKind fleetspaceApiKind() {
        return this.fleetspaceApiKind;
    }

    /**
     * Set the fleetspaceApiKind property: The kind of API this fleetspace belongs to. Acceptable values: 'NoSQL'.
     * 
     * @param fleetspaceApiKind the fleetspaceApiKind value to set.
     * @return the FleetspaceProperties object itself.
     */
    public FleetspaceProperties withFleetspaceApiKind(FleetspacePropertiesFleetspaceApiKind fleetspaceApiKind) {
        this.fleetspaceApiKind = fleetspaceApiKind;
        return this;
    }

    /**
     * Get the serviceTier property: Service Tier for the fleetspace. GeneralPurpose types refers to single write region
     * accounts that can be added to this fleetspace, whereas BusinessCritical refers to multi write region.
     * 
     * @return the serviceTier value.
     */
    public FleetspacePropertiesServiceTier serviceTier() {
        return this.serviceTier;
    }

    /**
     * Set the serviceTier property: Service Tier for the fleetspace. GeneralPurpose types refers to single write region
     * accounts that can be added to this fleetspace, whereas BusinessCritical refers to multi write region.
     * 
     * @param serviceTier the serviceTier value to set.
     * @return the FleetspaceProperties object itself.
     */
    public FleetspaceProperties withServiceTier(FleetspacePropertiesServiceTier serviceTier) {
        this.serviceTier = serviceTier;
        return this;
    }

    /**
     * Get the dataRegions property: List of data regions assigned to the fleetspace. Eg [westus2].
     * 
     * @return the dataRegions value.
     */
    public List<String> dataRegions() {
        return this.dataRegions;
    }

    /**
     * Set the dataRegions property: List of data regions assigned to the fleetspace. Eg [westus2].
     * 
     * @param dataRegions the dataRegions value to set.
     * @return the FleetspaceProperties object itself.
     */
    public FleetspaceProperties withDataRegions(List<String> dataRegions) {
        this.dataRegions = dataRegions;
        return this;
    }

    /**
     * Get the throughputPoolConfiguration property: Configuration for throughput pool in the fleetspace.
     * 
     * @return the throughputPoolConfiguration value.
     */
    public FleetspacePropertiesThroughputPoolConfiguration throughputPoolConfiguration() {
        return this.throughputPoolConfiguration;
    }

    /**
     * Set the throughputPoolConfiguration property: Configuration for throughput pool in the fleetspace.
     * 
     * @param throughputPoolConfiguration the throughputPoolConfiguration value to set.
     * @return the FleetspaceProperties object itself.
     */
    public FleetspaceProperties
        withThroughputPoolConfiguration(FleetspacePropertiesThroughputPoolConfiguration throughputPoolConfiguration) {
        this.throughputPoolConfiguration = throughputPoolConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (throughputPoolConfiguration() != null) {
            throughputPoolConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provisioningState",
            this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeStringField("fleetspaceApiKind",
            this.fleetspaceApiKind == null ? null : this.fleetspaceApiKind.toString());
        jsonWriter.writeStringField("serviceTier", this.serviceTier == null ? null : this.serviceTier.toString());
        jsonWriter.writeArrayField("dataRegions", this.dataRegions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("throughputPoolConfiguration", this.throughputPoolConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FleetspaceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FleetspaceProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FleetspaceProperties.
     */
    public static FleetspaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FleetspaceProperties deserializedFleetspaceProperties = new FleetspaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedFleetspaceProperties.provisioningState = Status.fromString(reader.getString());
                } else if ("fleetspaceApiKind".equals(fieldName)) {
                    deserializedFleetspaceProperties.fleetspaceApiKind
                        = FleetspacePropertiesFleetspaceApiKind.fromString(reader.getString());
                } else if ("serviceTier".equals(fieldName)) {
                    deserializedFleetspaceProperties.serviceTier
                        = FleetspacePropertiesServiceTier.fromString(reader.getString());
                } else if ("dataRegions".equals(fieldName)) {
                    List<String> dataRegions = reader.readArray(reader1 -> reader1.getString());
                    deserializedFleetspaceProperties.dataRegions = dataRegions;
                } else if ("throughputPoolConfiguration".equals(fieldName)) {
                    deserializedFleetspaceProperties.throughputPoolConfiguration
                        = FleetspacePropertiesThroughputPoolConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFleetspaceProperties;
        });
    }
}
