// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.FleetspaceAccountPropertiesGlobalDatabaseAccountProperties;
import com.azure.resourcemanager.cosmos.models.Status;
import java.io.IOException;

/**
 * An Azure Cosmos DB Fleetspace Account.
 */
@Fluent
public final class FleetspaceAccountResourceInner extends ProxyResource {
    /*
     * An Azure Cosmos DB Global Database Account which is part of a Fleetspace Account.
     */
    private FleetspaceAccountProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of FleetspaceAccountResourceInner class.
     */
    public FleetspaceAccountResourceInner() {
    }

    /**
     * Get the innerProperties property: An Azure Cosmos DB Global Database Account which is part of a Fleetspace
     * Account.
     * 
     * @return the innerProperties value.
     */
    private FleetspaceAccountProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: A provisioning state of the Fleetspace Account.
     * 
     * @return the provisioningState value.
     */
    public Status provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Set the provisioningState property: A provisioning state of the Fleetspace Account.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the FleetspaceAccountResourceInner object itself.
     */
    public FleetspaceAccountResourceInner withProvisioningState(Status provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceAccountProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    /**
     * Get the globalDatabaseAccountProperties property: Configuration for fleetspace Account in the fleetspace.
     * 
     * @return the globalDatabaseAccountProperties value.
     */
    public FleetspaceAccountPropertiesGlobalDatabaseAccountProperties globalDatabaseAccountProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().globalDatabaseAccountProperties();
    }

    /**
     * Set the globalDatabaseAccountProperties property: Configuration for fleetspace Account in the fleetspace.
     * 
     * @param globalDatabaseAccountProperties the globalDatabaseAccountProperties value to set.
     * @return the FleetspaceAccountResourceInner object itself.
     */
    public FleetspaceAccountResourceInner withGlobalDatabaseAccountProperties(
        FleetspaceAccountPropertiesGlobalDatabaseAccountProperties globalDatabaseAccountProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceAccountProperties();
        }
        this.innerProperties().withGlobalDatabaseAccountProperties(globalDatabaseAccountProperties);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FleetspaceAccountResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FleetspaceAccountResourceInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FleetspaceAccountResourceInner.
     */
    public static FleetspaceAccountResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FleetspaceAccountResourceInner deserializedFleetspaceAccountResourceInner
                = new FleetspaceAccountResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedFleetspaceAccountResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedFleetspaceAccountResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedFleetspaceAccountResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedFleetspaceAccountResourceInner.innerProperties
                        = FleetspaceAccountProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedFleetspaceAccountResourceInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFleetspaceAccountResourceInner;
        });
    }
}
