// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.FleetspaceAccountPropertiesGlobalDatabaseAccountProperties;
import com.azure.resourcemanager.cosmos.models.Status;
import java.io.IOException;

/**
 * An Azure Cosmos DB Global Database Account which is part of a Fleetspace Account.
 */
@Fluent
public final class FleetspaceAccountProperties implements JsonSerializable<FleetspaceAccountProperties> {
    /*
     * A provisioning state of the Fleetspace Account.
     */
    private Status provisioningState;

    /*
     * Configuration for fleetspace Account in the fleetspace.
     */
    private FleetspaceAccountPropertiesGlobalDatabaseAccountProperties globalDatabaseAccountProperties;

    /**
     * Creates an instance of FleetspaceAccountProperties class.
     */
    public FleetspaceAccountProperties() {
    }

    /**
     * Get the provisioningState property: A provisioning state of the Fleetspace Account.
     * 
     * @return the provisioningState value.
     */
    public Status provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: A provisioning state of the Fleetspace Account.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the FleetspaceAccountProperties object itself.
     */
    public FleetspaceAccountProperties withProvisioningState(Status provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the globalDatabaseAccountProperties property: Configuration for fleetspace Account in the fleetspace.
     * 
     * @return the globalDatabaseAccountProperties value.
     */
    public FleetspaceAccountPropertiesGlobalDatabaseAccountProperties globalDatabaseAccountProperties() {
        return this.globalDatabaseAccountProperties;
    }

    /**
     * Set the globalDatabaseAccountProperties property: Configuration for fleetspace Account in the fleetspace.
     * 
     * @param globalDatabaseAccountProperties the globalDatabaseAccountProperties value to set.
     * @return the FleetspaceAccountProperties object itself.
     */
    public FleetspaceAccountProperties withGlobalDatabaseAccountProperties(
        FleetspaceAccountPropertiesGlobalDatabaseAccountProperties globalDatabaseAccountProperties) {
        this.globalDatabaseAccountProperties = globalDatabaseAccountProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (globalDatabaseAccountProperties() != null) {
            globalDatabaseAccountProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provisioningState",
            this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeJsonField("globalDatabaseAccountProperties", this.globalDatabaseAccountProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FleetspaceAccountProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FleetspaceAccountProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FleetspaceAccountProperties.
     */
    public static FleetspaceAccountProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FleetspaceAccountProperties deserializedFleetspaceAccountProperties = new FleetspaceAccountProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedFleetspaceAccountProperties.provisioningState = Status.fromString(reader.getString());
                } else if ("globalDatabaseAccountProperties".equals(fieldName)) {
                    deserializedFleetspaceAccountProperties.globalDatabaseAccountProperties
                        = FleetspaceAccountPropertiesGlobalDatabaseAccountProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFleetspaceAccountProperties;
        });
    }
}
