// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.Status;
import java.io.IOException;

/**
 * Properties to update Azure Cosmos DB fleet resource.
 */
@Fluent
public final class FleetResourceProperties implements JsonSerializable<FleetResourceProperties> {
    /*
     * A provisioning state of the Fleet.
     */
    private Status provisioningState;

    /**
     * Creates an instance of FleetResourceProperties class.
     */
    public FleetResourceProperties() {
    }

    /**
     * Get the provisioningState property: A provisioning state of the Fleet.
     * 
     * @return the provisioningState value.
     */
    public Status provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: A provisioning state of the Fleet.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the FleetResourceProperties object itself.
     */
    public FleetResourceProperties withProvisioningState(Status provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provisioningState",
            this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FleetResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FleetResourceProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FleetResourceProperties.
     */
    public static FleetResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FleetResourceProperties deserializedFleetResourceProperties = new FleetResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedFleetResourceProperties.provisioningState = Status.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFleetResourceProperties;
        });
    }
}
