// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CassandraClusterPublicStatusDataCentersItem;
import com.azure.resourcemanager.cosmos.models.CassandraError;
import com.azure.resourcemanager.cosmos.models.ConnectionError;
import com.azure.resourcemanager.cosmos.models.ManagedCassandraReaperStatus;
import java.io.IOException;
import java.util.List;

/**
 * Properties of a managed Cassandra cluster public status.
 */
@Fluent
public final class CassandraClusterPublicStatusInner implements JsonSerializable<CassandraClusterPublicStatusInner> {
    /*
     * The eTag property.
     */
    private String etag;

    /*
     * The reaperStatus property.
     */
    private ManagedCassandraReaperStatus reaperStatus;

    /*
     * List relevant information about any connection errors to the Datacenters.
     */
    private List<ConnectionError> connectionErrors;

    /*
     * List relevant information about any errors about cluster, data center and connection error.
     */
    private List<CassandraError> errors;

    /*
     * List of the status of each datacenter in this cluster.
     */
    private List<CassandraClusterPublicStatusDataCentersItem> dataCenters;

    /**
     * Creates an instance of CassandraClusterPublicStatusInner class.
     */
    public CassandraClusterPublicStatusInner() {
    }

    /**
     * Get the etag property: The eTag property.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: The eTag property.
     * 
     * @param etag the etag value to set.
     * @return the CassandraClusterPublicStatusInner object itself.
     */
    public CassandraClusterPublicStatusInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the reaperStatus property: The reaperStatus property.
     * 
     * @return the reaperStatus value.
     */
    public ManagedCassandraReaperStatus reaperStatus() {
        return this.reaperStatus;
    }

    /**
     * Set the reaperStatus property: The reaperStatus property.
     * 
     * @param reaperStatus the reaperStatus value to set.
     * @return the CassandraClusterPublicStatusInner object itself.
     */
    public CassandraClusterPublicStatusInner withReaperStatus(ManagedCassandraReaperStatus reaperStatus) {
        this.reaperStatus = reaperStatus;
        return this;
    }

    /**
     * Get the connectionErrors property: List relevant information about any connection errors to the Datacenters.
     * 
     * @return the connectionErrors value.
     */
    public List<ConnectionError> connectionErrors() {
        return this.connectionErrors;
    }

    /**
     * Set the connectionErrors property: List relevant information about any connection errors to the Datacenters.
     * 
     * @param connectionErrors the connectionErrors value to set.
     * @return the CassandraClusterPublicStatusInner object itself.
     */
    public CassandraClusterPublicStatusInner withConnectionErrors(List<ConnectionError> connectionErrors) {
        this.connectionErrors = connectionErrors;
        return this;
    }

    /**
     * Get the errors property: List relevant information about any errors about cluster, data center and connection
     * error.
     * 
     * @return the errors value.
     */
    public List<CassandraError> errors() {
        return this.errors;
    }

    /**
     * Set the errors property: List relevant information about any errors about cluster, data center and connection
     * error.
     * 
     * @param errors the errors value to set.
     * @return the CassandraClusterPublicStatusInner object itself.
     */
    public CassandraClusterPublicStatusInner withErrors(List<CassandraError> errors) {
        this.errors = errors;
        return this;
    }

    /**
     * Get the dataCenters property: List of the status of each datacenter in this cluster.
     * 
     * @return the dataCenters value.
     */
    public List<CassandraClusterPublicStatusDataCentersItem> dataCenters() {
        return this.dataCenters;
    }

    /**
     * Set the dataCenters property: List of the status of each datacenter in this cluster.
     * 
     * @param dataCenters the dataCenters value to set.
     * @return the CassandraClusterPublicStatusInner object itself.
     */
    public CassandraClusterPublicStatusInner
        withDataCenters(List<CassandraClusterPublicStatusDataCentersItem> dataCenters) {
        this.dataCenters = dataCenters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (reaperStatus() != null) {
            reaperStatus().validate();
        }
        if (connectionErrors() != null) {
            connectionErrors().forEach(e -> e.validate());
        }
        if (errors() != null) {
            errors().forEach(e -> e.validate());
        }
        if (dataCenters() != null) {
            dataCenters().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("eTag", this.etag);
        jsonWriter.writeJsonField("reaperStatus", this.reaperStatus);
        jsonWriter.writeArrayField("connectionErrors", this.connectionErrors,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("dataCenters", this.dataCenters, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CassandraClusterPublicStatusInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CassandraClusterPublicStatusInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CassandraClusterPublicStatusInner.
     */
    public static CassandraClusterPublicStatusInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CassandraClusterPublicStatusInner deserializedCassandraClusterPublicStatusInner
                = new CassandraClusterPublicStatusInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("eTag".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusInner.etag = reader.getString();
                } else if ("reaperStatus".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusInner.reaperStatus
                        = ManagedCassandraReaperStatus.fromJson(reader);
                } else if ("connectionErrors".equals(fieldName)) {
                    List<ConnectionError> connectionErrors
                        = reader.readArray(reader1 -> ConnectionError.fromJson(reader1));
                    deserializedCassandraClusterPublicStatusInner.connectionErrors = connectionErrors;
                } else if ("errors".equals(fieldName)) {
                    List<CassandraError> errors = reader.readArray(reader1 -> CassandraError.fromJson(reader1));
                    deserializedCassandraClusterPublicStatusInner.errors = errors;
                } else if ("dataCenters".equals(fieldName)) {
                    List<CassandraClusterPublicStatusDataCentersItem> dataCenters
                        = reader.readArray(reader1 -> CassandraClusterPublicStatusDataCentersItem.fromJson(reader1));
                    deserializedCassandraClusterPublicStatusInner.dataCenters = dataCenters;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCassandraClusterPublicStatusInner;
        });
    }
}
