// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.models.FleetspaceResourceInner;
import com.azure.resourcemanager.cosmos.models.FleetspaceUpdate;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in FleetspacesClient.
 */
public interface FleetspacesClient {
    /**
     * Lists all the fleetspaces under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleetspaces and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<FleetspaceResourceInner> listAsync(String resourceGroupName, String fleetName);

    /**
     * Lists all the fleetspaces under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleetspaces and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FleetspaceResourceInner> list(String resourceGroupName, String fleetName);

    /**
     * Lists all the fleetspaces under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleetspaces and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FleetspaceResourceInner> list(String resourceGroupName, String fleetName, Context context);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FleetspaceResourceInner>> getWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FleetspaceResourceInner> getAsync(String resourceGroupName, String fleetName, String fleetspaceName);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FleetspaceResourceInner> getWithResponse(String resourceGroupName, String fleetName, String fleetspaceName,
        Context context);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FleetspaceResourceInner get(String resourceGroupName, String fleetName, String fleetspaceName);

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, FleetspaceResourceInner body);

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginCreateAsync(String resourceGroupName,
        String fleetName, String fleetspaceName, FleetspaceResourceInner body);

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginCreate(String resourceGroupName,
        String fleetName, String fleetspaceName, FleetspaceResourceInner body);

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginCreate(String resourceGroupName,
        String fleetName, String fleetspaceName, FleetspaceResourceInner body, Context context);

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FleetspaceResourceInner> createAsync(String resourceGroupName, String fleetName, String fleetspaceName,
        FleetspaceResourceInner body);

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FleetspaceResourceInner create(String resourceGroupName, String fleetName, String fleetspaceName,
        FleetspaceResourceInner body);

    /**
     * Creates an Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FleetspaceResourceInner create(String resourceGroupName, String fleetName, String fleetspaceName,
        FleetspaceResourceInner body, Context context);

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, FleetspaceUpdate body);

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginUpdateAsync(String resourceGroupName,
        String fleetName, String fleetspaceName, FleetspaceUpdate body);

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginUpdateAsync(String resourceGroupName,
        String fleetName, String fleetspaceName);

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginUpdate(String resourceGroupName,
        String fleetName, String fleetspaceName);

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FleetspaceResourceInner>, FleetspaceResourceInner> beginUpdate(String resourceGroupName,
        String fleetName, String fleetspaceName, FleetspaceUpdate body, Context context);

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FleetspaceResourceInner> updateAsync(String resourceGroupName, String fleetName, String fleetspaceName,
        FleetspaceUpdate body);

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FleetspaceResourceInner> updateAsync(String resourceGroupName, String fleetName, String fleetspaceName);

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FleetspaceResourceInner update(String resourceGroupName, String fleetName, String fleetspaceName);

    /**
     * Update the properties of an existing Azure Cosmos DB fleetspace under a fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param body The parameters to provide for the current fleetspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FleetspaceResourceInner update(String resourceGroupName, String fleetName, String fleetspaceName,
        FleetspaceUpdate body, Context context);

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName);

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String fleetName,
        String fleetspaceName);

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName, String fleetspaceName);

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName, String fleetspaceName,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String fleetName, String fleetspaceName);

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String fleetName, String fleetspaceName);

    /**
     * Deletes an existing Azure Cosmos DB Fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String fleetName, String fleetspaceName, Context context);
}
