// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.models.FleetspaceAccountResourceInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in FleetspaceAccountsClient.
 */
public interface FleetspaceAccountsClient {
    /**
     * Lists all the fleetspaces accounts under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the global database accounts and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<FleetspaceAccountResourceInner> listAsync(String resourceGroupName, String fleetName,
        String fleetspaceName);

    /**
     * Lists all the fleetspaces accounts under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the global database accounts and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FleetspaceAccountResourceInner> list(String resourceGroupName, String fleetName,
        String fleetspaceName);

    /**
     * Lists all the fleetspaces accounts under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the global database accounts and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FleetspaceAccountResourceInner> list(String resourceGroupName, String fleetName,
        String fleetspaceName, Context context);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FleetspaceAccountResourceInner>> getWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FleetspaceAccountResourceInner> getAsync(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FleetspaceAccountResourceInner> getWithResponse(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName, Context context);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FleetspaceAccountResourceInner get(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName);

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName, FleetspaceAccountResourceInner body);

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<FleetspaceAccountResourceInner>, FleetspaceAccountResourceInner> beginCreateAsync(
        String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName,
        FleetspaceAccountResourceInner body);

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FleetspaceAccountResourceInner>, FleetspaceAccountResourceInner> beginCreate(
        String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName,
        FleetspaceAccountResourceInner body);

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FleetspaceAccountResourceInner>, FleetspaceAccountResourceInner> beginCreate(
        String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName,
        FleetspaceAccountResourceInner body, Context context);

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FleetspaceAccountResourceInner> createAsync(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName, FleetspaceAccountResourceInner body);

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FleetspaceAccountResourceInner create(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName, FleetspaceAccountResourceInner body);

    /**
     * Creates an Azure Cosmos DB fleetspace account under a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param body The parameters to provide for the current fleetspace account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Fleetspace Account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FleetspaceAccountResourceInner create(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName, FleetspaceAccountResourceInner body, Context context);

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName);

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String fleetName,
        String fleetspaceName, String fleetspaceAccountName);

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName);

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName, Context context);

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String fleetName, String fleetspaceName,
        String fleetspaceAccountName);

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName);

    /**
     * Removes an existing Azure Cosmos DB fleetspace account from a fleetspace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param fleetspaceName Cosmos DB fleetspace name. Needs to be unique under a fleet.
     * @param fleetspaceAccountName Cosmos DB fleetspace account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String fleetName, String fleetspaceName, String fleetspaceAccountName,
        Context context);
}
