// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.models.FleetResourceInner;
import com.azure.resourcemanager.cosmos.models.FleetResourceUpdate;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in FleetsClient.
 */
public interface FleetsClient
    extends InnerSupportsGet<FleetResourceInner>, InnerSupportsListing<FleetResourceInner>, InnerSupportsDelete<Void> {
    /**
     * Lists all the fleets under the subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleets and their properties as paginated response
     * with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<FleetResourceInner> listAsync();

    /**
     * Lists all the fleets under the subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleets and their properties as paginated response
     * with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FleetResourceInner> list();

    /**
     * Lists all the fleets under the subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleets and their properties as paginated response
     * with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FleetResourceInner> list(Context context);

    /**
     * Lists all the fleets under the specified subscription and resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleets and their properties as paginated response
     * with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<FleetResourceInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Lists all the fleets under the specified subscription and resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleets and their properties as paginated response
     * with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FleetResourceInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists all the fleets under the specified subscription and resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List operation that contains the fleets and their properties as paginated response
     * with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FleetResourceInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleet under a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB FleetResource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FleetResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String fleetName);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleet under a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB FleetResource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FleetResourceInner> getByResourceGroupAsync(String resourceGroupName, String fleetName);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleet under a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB FleetResource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FleetResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String fleetName,
        Context context);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB fleet under a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB FleetResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FleetResourceInner getByResourceGroup(String resourceGroupName, String fleetName);

    /**
     * Creates an Azure Cosmos DB fleet under a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param body The parameters to provide for the current fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB FleetResource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FleetResourceInner>> createWithResponseAsync(String resourceGroupName, String fleetName,
        FleetResourceInner body);

    /**
     * Creates an Azure Cosmos DB fleet under a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param body The parameters to provide for the current fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB FleetResource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FleetResourceInner> createAsync(String resourceGroupName, String fleetName, FleetResourceInner body);

    /**
     * Creates an Azure Cosmos DB fleet under a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param body The parameters to provide for the current fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB FleetResource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FleetResourceInner> createWithResponse(String resourceGroupName, String fleetName, FleetResourceInner body,
        Context context);

    /**
     * Creates an Azure Cosmos DB fleet under a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param body The parameters to provide for the current fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB FleetResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FleetResourceInner create(String resourceGroupName, String fleetName, FleetResourceInner body);

    /**
     * Updates the properties of an existing Azure Cosmos DB Fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param body The parameters to provide for the current fleet.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB FleetResource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FleetResourceInner>> updateWithResponseAsync(String resourceGroupName, String fleetName,
        FleetResourceUpdate body);

    /**
     * Updates the properties of an existing Azure Cosmos DB Fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB FleetResource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FleetResourceInner> updateAsync(String resourceGroupName, String fleetName);

    /**
     * Updates the properties of an existing Azure Cosmos DB Fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param body The parameters to provide for the current fleet.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB FleetResource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FleetResourceInner> updateWithResponse(String resourceGroupName, String fleetName,
        FleetResourceUpdate body, Context context);

    /**
     * Updates the properties of an existing Azure Cosmos DB Fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB FleetResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FleetResourceInner update(String resourceGroupName, String fleetName);

    /**
     * Deletes an existing Azure Cosmos DB Fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String fleetName);

    /**
     * Deletes an existing Azure Cosmos DB Fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String fleetName);

    /**
     * Deletes an existing Azure Cosmos DB Fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName);

    /**
     * Deletes an existing Azure Cosmos DB Fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String fleetName, Context context);

    /**
     * Deletes an existing Azure Cosmos DB Fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String fleetName);

    /**
     * Deletes an existing Azure Cosmos DB Fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String fleetName);

    /**
     * Deletes an existing Azure Cosmos DB Fleet.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param fleetName Cosmos DB fleet name. Needs to be unique under a subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String fleetName, Context context);
}
