// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent;

import com.azure.core.http.HttpPipeline;
import java.time.Duration;

/**
 * The interface for CosmosDBManagementClient class.
 */
public interface CosmosDBManagementClient {
    /**
     * Gets The ID of the target subscription.
     * 
     * @return the subscriptionId value.
     */
    String getSubscriptionId();

    /**
     * Gets server parameter.
     * 
     * @return the endpoint value.
     */
    String getEndpoint();

    /**
     * Gets Api Version.
     * 
     * @return the apiVersion value.
     */
    String getApiVersion();

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    HttpPipeline getHttpPipeline();

    /**
     * Gets The default poll interval for long-running operation.
     * 
     * @return the defaultPollInterval value.
     */
    Duration getDefaultPollInterval();

    /**
     * Gets the DatabaseAccountsClient object to access its operations.
     * 
     * @return the DatabaseAccountsClient object.
     */
    DatabaseAccountsClient getDatabaseAccounts();

    /**
     * Gets the OperationsClient object to access its operations.
     * 
     * @return the OperationsClient object.
     */
    OperationsClient getOperations();

    /**
     * Gets the DatabasesClient object to access its operations.
     * 
     * @return the DatabasesClient object.
     */
    DatabasesClient getDatabases();

    /**
     * Gets the CollectionsClient object to access its operations.
     * 
     * @return the CollectionsClient object.
     */
    CollectionsClient getCollections();

    /**
     * Gets the CollectionRegionsClient object to access its operations.
     * 
     * @return the CollectionRegionsClient object.
     */
    CollectionRegionsClient getCollectionRegions();

    /**
     * Gets the DatabaseAccountRegionsClient object to access its operations.
     * 
     * @return the DatabaseAccountRegionsClient object.
     */
    DatabaseAccountRegionsClient getDatabaseAccountRegions();

    /**
     * Gets the PercentileSourceTargetsClient object to access its operations.
     * 
     * @return the PercentileSourceTargetsClient object.
     */
    PercentileSourceTargetsClient getPercentileSourceTargets();

    /**
     * Gets the PercentileTargetsClient object to access its operations.
     * 
     * @return the PercentileTargetsClient object.
     */
    PercentileTargetsClient getPercentileTargets();

    /**
     * Gets the PercentilesClient object to access its operations.
     * 
     * @return the PercentilesClient object.
     */
    PercentilesClient getPercentiles();

    /**
     * Gets the CollectionPartitionRegionsClient object to access its operations.
     * 
     * @return the CollectionPartitionRegionsClient object.
     */
    CollectionPartitionRegionsClient getCollectionPartitionRegions();

    /**
     * Gets the CollectionPartitionsClient object to access its operations.
     * 
     * @return the CollectionPartitionsClient object.
     */
    CollectionPartitionsClient getCollectionPartitions();

    /**
     * Gets the PartitionKeyRangeIdsClient object to access its operations.
     * 
     * @return the PartitionKeyRangeIdsClient object.
     */
    PartitionKeyRangeIdsClient getPartitionKeyRangeIds();

    /**
     * Gets the PartitionKeyRangeIdRegionsClient object to access its operations.
     * 
     * @return the PartitionKeyRangeIdRegionsClient object.
     */
    PartitionKeyRangeIdRegionsClient getPartitionKeyRangeIdRegions();

    /**
     * Gets the SqlResourcesClient object to access its operations.
     * 
     * @return the SqlResourcesClient object.
     */
    SqlResourcesClient getSqlResources();

    /**
     * Gets the MongoDBResourcesClient object to access its operations.
     * 
     * @return the MongoDBResourcesClient object.
     */
    MongoDBResourcesClient getMongoDBResources();

    /**
     * Gets the TableResourcesClient object to access its operations.
     * 
     * @return the TableResourcesClient object.
     */
    TableResourcesClient getTableResources();

    /**
     * Gets the CassandraResourcesClient object to access its operations.
     * 
     * @return the CassandraResourcesClient object.
     */
    CassandraResourcesClient getCassandraResources();

    /**
     * Gets the GremlinResourcesClient object to access its operations.
     * 
     * @return the GremlinResourcesClient object.
     */
    GremlinResourcesClient getGremlinResources();

    /**
     * Gets the LocationsClient object to access its operations.
     * 
     * @return the LocationsClient object.
     */
    LocationsClient getLocations();

    /**
     * Gets the CassandraClustersClient object to access its operations.
     * 
     * @return the CassandraClustersClient object.
     */
    CassandraClustersClient getCassandraClusters();

    /**
     * Gets the CassandraDataCentersClient object to access its operations.
     * 
     * @return the CassandraDataCentersClient object.
     */
    CassandraDataCentersClient getCassandraDataCenters();

    /**
     * Gets the NotebookWorkspacesClient object to access its operations.
     * 
     * @return the NotebookWorkspacesClient object.
     */
    NotebookWorkspacesClient getNotebookWorkspaces();

    /**
     * Gets the PrivateEndpointConnectionsClient object to access its operations.
     * 
     * @return the PrivateEndpointConnectionsClient object.
     */
    PrivateEndpointConnectionsClient getPrivateEndpointConnections();

    /**
     * Gets the PrivateLinkResourcesClient object to access its operations.
     * 
     * @return the PrivateLinkResourcesClient object.
     */
    PrivateLinkResourcesClient getPrivateLinkResources();

    /**
     * Gets the RestorableDatabaseAccountsClient object to access its operations.
     * 
     * @return the RestorableDatabaseAccountsClient object.
     */
    RestorableDatabaseAccountsClient getRestorableDatabaseAccounts();

    /**
     * Gets the RestorableSqlDatabasesClient object to access its operations.
     * 
     * @return the RestorableSqlDatabasesClient object.
     */
    RestorableSqlDatabasesClient getRestorableSqlDatabases();

    /**
     * Gets the RestorableSqlContainersClient object to access its operations.
     * 
     * @return the RestorableSqlContainersClient object.
     */
    RestorableSqlContainersClient getRestorableSqlContainers();

    /**
     * Gets the RestorableSqlResourcesClient object to access its operations.
     * 
     * @return the RestorableSqlResourcesClient object.
     */
    RestorableSqlResourcesClient getRestorableSqlResources();

    /**
     * Gets the RestorableMongodbDatabasesClient object to access its operations.
     * 
     * @return the RestorableMongodbDatabasesClient object.
     */
    RestorableMongodbDatabasesClient getRestorableMongodbDatabases();

    /**
     * Gets the RestorableMongodbCollectionsClient object to access its operations.
     * 
     * @return the RestorableMongodbCollectionsClient object.
     */
    RestorableMongodbCollectionsClient getRestorableMongodbCollections();

    /**
     * Gets the RestorableMongodbResourcesClient object to access its operations.
     * 
     * @return the RestorableMongodbResourcesClient object.
     */
    RestorableMongodbResourcesClient getRestorableMongodbResources();

    /**
     * Gets the RestorableGremlinDatabasesClient object to access its operations.
     * 
     * @return the RestorableGremlinDatabasesClient object.
     */
    RestorableGremlinDatabasesClient getRestorableGremlinDatabases();

    /**
     * Gets the RestorableGremlinGraphsClient object to access its operations.
     * 
     * @return the RestorableGremlinGraphsClient object.
     */
    RestorableGremlinGraphsClient getRestorableGremlinGraphs();

    /**
     * Gets the RestorableGremlinResourcesClient object to access its operations.
     * 
     * @return the RestorableGremlinResourcesClient object.
     */
    RestorableGremlinResourcesClient getRestorableGremlinResources();

    /**
     * Gets the RestorableTablesClient object to access its operations.
     * 
     * @return the RestorableTablesClient object.
     */
    RestorableTablesClient getRestorableTables();

    /**
     * Gets the RestorableTableResourcesClient object to access its operations.
     * 
     * @return the RestorableTableResourcesClient object.
     */
    RestorableTableResourcesClient getRestorableTableResources();

    /**
     * Gets the ServicesClient object to access its operations.
     * 
     * @return the ServicesClient object.
     */
    ServicesClient getServices();

    /**
     * Gets the FleetsClient object to access its operations.
     * 
     * @return the FleetsClient object.
     */
    FleetsClient getFleets();

    /**
     * Gets the FleetspacesClient object to access its operations.
     * 
     * @return the FleetspacesClient object.
     */
    FleetspacesClient getFleetspaces();

    /**
     * Gets the FleetspaceAccountsClient object to access its operations.
     * 
     * @return the FleetspaceAccountsClient object.
     */
    FleetspaceAccountsClient getFleetspaceAccounts();
}
