/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CassandraSchema;
import java.io.IOException;

public class CassandraTableResource
implements JsonSerializable<CassandraTableResource> {
    private String id;
    private Integer defaultTtl;
    private CassandraSchema schema;
    private Integer analyticalStorageTtl;
    private static final ClientLogger LOGGER = new ClientLogger(CassandraTableResource.class);

    public String id() {
        return this.id;
    }

    public CassandraTableResource withId(String id) {
        this.id = id;
        return this;
    }

    public Integer defaultTtl() {
        return this.defaultTtl;
    }

    public CassandraTableResource withDefaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    public CassandraSchema schema() {
        return this.schema;
    }

    public CassandraTableResource withSchema(CassandraSchema schema) {
        this.schema = schema;
        return this;
    }

    public Integer analyticalStorageTtl() {
        return this.analyticalStorageTtl;
    }

    public CassandraTableResource withAnalyticalStorageTtl(Integer analyticalStorageTtl) {
        this.analyticalStorageTtl = analyticalStorageTtl;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model CassandraTableResource"));
        }
        if (this.schema() != null) {
            this.schema().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeNumberField("defaultTtl", (Number)this.defaultTtl);
        jsonWriter.writeJsonField("schema", (JsonSerializable)this.schema);
        jsonWriter.writeNumberField("analyticalStorageTtl", (Number)this.analyticalStorageTtl);
        return jsonWriter.writeEndObject();
    }

    public static CassandraTableResource fromJson(JsonReader jsonReader) throws IOException {
        return (CassandraTableResource)jsonReader.readObject(reader -> {
            CassandraTableResource deserializedCassandraTableResource = new CassandraTableResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCassandraTableResource.id = reader.getString();
                    continue;
                }
                if ("defaultTtl".equals(fieldName)) {
                    deserializedCassandraTableResource.defaultTtl = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedCassandraTableResource.schema = CassandraSchema.fromJson(reader);
                    continue;
                }
                if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedCassandraTableResource.analyticalStorageTtl = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCassandraTableResource;
        });
    }
}

