// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB options resource object.
 */
@Fluent
public class OptionsResource implements JsonSerializable<OptionsResource> {
    /*
     * Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when
     * retrieving offer details.
     */
    private Integer throughput;

    /*
     * Specifies the Autoscale settings.
     */
    private AutoscaleSettings autoscaleSettings;

    /**
     * Creates an instance of OptionsResource class.
     */
    public OptionsResource() {
    }

    /**
     * Get the throughput property: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
     * ThroughputSetting resource when retrieving offer details.
     * 
     * @return the throughput value.
     */
    public Integer throughput() {
        return this.throughput;
    }

    /**
     * Set the throughput property: Value of the Cosmos DB resource throughput or autoscaleSettings. Use the
     * ThroughputSetting resource when retrieving offer details.
     * 
     * @param throughput the throughput value to set.
     * @return the OptionsResource object itself.
     */
    public OptionsResource withThroughput(Integer throughput) {
        this.throughput = throughput;
        return this;
    }

    /**
     * Get the autoscaleSettings property: Specifies the Autoscale settings.
     * 
     * @return the autoscaleSettings value.
     */
    public AutoscaleSettings autoscaleSettings() {
        return this.autoscaleSettings;
    }

    /**
     * Set the autoscaleSettings property: Specifies the Autoscale settings.
     * 
     * @param autoscaleSettings the autoscaleSettings value to set.
     * @return the OptionsResource object itself.
     */
    public OptionsResource withAutoscaleSettings(AutoscaleSettings autoscaleSettings) {
        this.autoscaleSettings = autoscaleSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (autoscaleSettings() != null) {
            autoscaleSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("throughput", this.throughput);
        jsonWriter.writeJsonField("autoscaleSettings", this.autoscaleSettings);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OptionsResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OptionsResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OptionsResource.
     */
    public static OptionsResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OptionsResource deserializedOptionsResource = new OptionsResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("throughput".equals(fieldName)) {
                    deserializedOptionsResource.throughput = reader.getNullable(JsonReader::getInt);
                } else if ("autoscaleSettings".equals(fieldName)) {
                    deserializedOptionsResource.autoscaleSettings = AutoscaleSettings.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOptionsResource;
        });
    }
}
