// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties for Create or Update request for MaterializedViewsBuilderServiceResource.
 */
@Fluent
public final class MaterializedViewsBuilderServiceResourceCreateUpdateParameters
    extends ServiceResourceCreateUpdateProperties {
    /*
     * ServiceType for the service.
     */
    private ServiceType serviceType = ServiceType.MATERIALIZED_VIEWS_BUILDER;

    /**
     * Creates an instance of MaterializedViewsBuilderServiceResourceCreateUpdateParameters class.
     */
    public MaterializedViewsBuilderServiceResourceCreateUpdateParameters() {
    }

    /**
     * Get the serviceType property: ServiceType for the service.
     * 
     * @return the serviceType value.
     */
    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MaterializedViewsBuilderServiceResourceCreateUpdateParameters withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MaterializedViewsBuilderServiceResourceCreateUpdateParameters withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("instanceSize", instanceSize() == null ? null : instanceSize().toString());
        jsonWriter.writeNumberField("instanceCount", instanceCount());
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MaterializedViewsBuilderServiceResourceCreateUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MaterializedViewsBuilderServiceResourceCreateUpdateParameters if the JsonReader was
     * pointing to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * MaterializedViewsBuilderServiceResourceCreateUpdateParameters.
     */
    public static MaterializedViewsBuilderServiceResourceCreateUpdateParameters fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            MaterializedViewsBuilderServiceResourceCreateUpdateParameters deserializedMaterializedViewsBuilderServiceResourceCreateUpdateParameters
                = new MaterializedViewsBuilderServiceResourceCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("instanceSize".equals(fieldName)) {
                    deserializedMaterializedViewsBuilderServiceResourceCreateUpdateParameters
                        .withInstanceSize(ServiceSize.fromString(reader.getString()));
                } else if ("instanceCount".equals(fieldName)) {
                    deserializedMaterializedViewsBuilderServiceResourceCreateUpdateParameters
                        .withInstanceCount(reader.getNullable(JsonReader::getInt));
                } else if ("serviceType".equals(fieldName)) {
                    deserializedMaterializedViewsBuilderServiceResourceCreateUpdateParameters.serviceType
                        = ServiceType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMaterializedViewsBuilderServiceResourceCreateUpdateParameters;
        });
    }
}
