// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.ClusterResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * List of managed Cassandra clusters.
 */
@Fluent
public final class ListClusters implements JsonSerializable<ListClusters> {
    /*
     * Container for the array of clusters.
     */
    private List<ClusterResourceInner> value;

    /**
     * Creates an instance of ListClusters class.
     */
    public ListClusters() {
    }

    /**
     * Get the value property: Container for the array of clusters.
     * 
     * @return the value value.
     */
    public List<ClusterResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Container for the array of clusters.
     * 
     * @param value the value value to set.
     * @return the ListClusters object itself.
     */
    public ListClusters withValue(List<ClusterResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListClusters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListClusters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListClusters.
     */
    public static ListClusters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListClusters deserializedListClusters = new ListClusters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ClusterResourceInner> value
                        = reader.readArray(reader1 -> ClusterResourceInner.fromJson(reader1));
                    deserializedListClusters.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListClusters;
        });
    }
}
