// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties for Create or Update request for GraphAPIComputeServiceResource.
 */
@Fluent
public final class GraphApiComputeServiceResourceCreateUpdateParameters extends ServiceResourceCreateUpdateProperties {
    /*
     * ServiceType for the service.
     */
    private ServiceType serviceType = ServiceType.GRAPH_APICOMPUTE;

    /**
     * Creates an instance of GraphApiComputeServiceResourceCreateUpdateParameters class.
     */
    public GraphApiComputeServiceResourceCreateUpdateParameters() {
    }

    /**
     * Get the serviceType property: ServiceType for the service.
     * 
     * @return the serviceType value.
     */
    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GraphApiComputeServiceResourceCreateUpdateParameters withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GraphApiComputeServiceResourceCreateUpdateParameters withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("instanceSize", instanceSize() == null ? null : instanceSize().toString());
        jsonWriter.writeNumberField("instanceCount", instanceCount());
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GraphApiComputeServiceResourceCreateUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GraphApiComputeServiceResourceCreateUpdateParameters if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GraphApiComputeServiceResourceCreateUpdateParameters.
     */
    public static GraphApiComputeServiceResourceCreateUpdateParameters fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            GraphApiComputeServiceResourceCreateUpdateParameters deserializedGraphApiComputeServiceResourceCreateUpdateParameters
                = new GraphApiComputeServiceResourceCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("instanceSize".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceCreateUpdateParameters
                        .withInstanceSize(ServiceSize.fromString(reader.getString()));
                } else if ("instanceCount".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceCreateUpdateParameters
                        .withInstanceCount(reader.getNullable(JsonReader::getInt));
                } else if ("serviceType".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceCreateUpdateParameters.serviceType
                        = ServiceType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGraphApiComputeServiceResourceCreateUpdateParameters;
        });
    }
}
