/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CompositePath;
import com.azure.resourcemanager.cosmos.models.ExcludedPath;
import com.azure.resourcemanager.cosmos.models.IncludedPath;
import com.azure.resourcemanager.cosmos.models.IndexingMode;
import com.azure.resourcemanager.cosmos.models.SpatialSpec;
import com.azure.resourcemanager.cosmos.models.VectorIndex;
import java.io.IOException;
import java.util.List;

public final class IndexingPolicy
implements JsonSerializable<IndexingPolicy> {
    private Boolean automatic;
    private IndexingMode indexingMode;
    private List<IncludedPath> includedPaths;
    private List<ExcludedPath> excludedPaths;
    private List<List<CompositePath>> compositeIndexes;
    private List<SpatialSpec> spatialIndexes;
    private List<VectorIndex> vectorIndexes;

    public Boolean automatic() {
        return this.automatic;
    }

    public IndexingPolicy withAutomatic(Boolean automatic) {
        this.automatic = automatic;
        return this;
    }

    public IndexingMode indexingMode() {
        return this.indexingMode;
    }

    public IndexingPolicy withIndexingMode(IndexingMode indexingMode) {
        this.indexingMode = indexingMode;
        return this;
    }

    public List<IncludedPath> includedPaths() {
        return this.includedPaths;
    }

    public IndexingPolicy withIncludedPaths(List<IncludedPath> includedPaths) {
        this.includedPaths = includedPaths;
        return this;
    }

    public List<ExcludedPath> excludedPaths() {
        return this.excludedPaths;
    }

    public IndexingPolicy withExcludedPaths(List<ExcludedPath> excludedPaths) {
        this.excludedPaths = excludedPaths;
        return this;
    }

    public List<List<CompositePath>> compositeIndexes() {
        return this.compositeIndexes;
    }

    public IndexingPolicy withCompositeIndexes(List<List<CompositePath>> compositeIndexes) {
        this.compositeIndexes = compositeIndexes;
        return this;
    }

    public List<SpatialSpec> spatialIndexes() {
        return this.spatialIndexes;
    }

    public IndexingPolicy withSpatialIndexes(List<SpatialSpec> spatialIndexes) {
        this.spatialIndexes = spatialIndexes;
        return this;
    }

    public List<VectorIndex> vectorIndexes() {
        return this.vectorIndexes;
    }

    public IndexingPolicy withVectorIndexes(List<VectorIndex> vectorIndexes) {
        this.vectorIndexes = vectorIndexes;
        return this;
    }

    public void validate() {
        if (this.includedPaths() != null) {
            this.includedPaths().forEach(e -> e.validate());
        }
        if (this.excludedPaths() != null) {
            this.excludedPaths().forEach(e -> e.validate());
        }
        if (this.compositeIndexes() != null) {
            this.compositeIndexes().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
        if (this.spatialIndexes() != null) {
            this.spatialIndexes().forEach(e -> e.validate());
        }
        if (this.vectorIndexes() != null) {
            this.vectorIndexes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("automatic", this.automatic);
        jsonWriter.writeStringField("indexingMode", this.indexingMode == null ? null : this.indexingMode.toString());
        jsonWriter.writeArrayField("includedPaths", this.includedPaths, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("excludedPaths", this.excludedPaths, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("compositeIndexes", this.compositeIndexes, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeJson((JsonSerializable)element1)));
        jsonWriter.writeArrayField("spatialIndexes", this.spatialIndexes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("vectorIndexes", this.vectorIndexes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static IndexingPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (IndexingPolicy)jsonReader.readObject(reader -> {
            IndexingPolicy deserializedIndexingPolicy = new IndexingPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("automatic".equals(fieldName)) {
                    deserializedIndexingPolicy.automatic = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("indexingMode".equals(fieldName)) {
                    deserializedIndexingPolicy.indexingMode = IndexingMode.fromString(reader.getString());
                    continue;
                }
                if ("includedPaths".equals(fieldName)) {
                    List includedPaths;
                    deserializedIndexingPolicy.includedPaths = includedPaths = reader.readArray(reader1 -> IncludedPath.fromJson(reader1));
                    continue;
                }
                if ("excludedPaths".equals(fieldName)) {
                    List excludedPaths;
                    deserializedIndexingPolicy.excludedPaths = excludedPaths = reader.readArray(reader1 -> ExcludedPath.fromJson(reader1));
                    continue;
                }
                if ("compositeIndexes".equals(fieldName)) {
                    List compositeIndexes;
                    deserializedIndexingPolicy.compositeIndexes = compositeIndexes = reader.readArray(reader1 -> reader1.readArray(reader2 -> CompositePath.fromJson(reader2)));
                    continue;
                }
                if ("spatialIndexes".equals(fieldName)) {
                    List spatialIndexes;
                    deserializedIndexingPolicy.spatialIndexes = spatialIndexes = reader.readArray(reader1 -> SpatialSpec.fromJson(reader1));
                    continue;
                }
                if ("vectorIndexes".equals(fieldName)) {
                    List vectorIndexes;
                    deserializedIndexingPolicy.vectorIndexes = vectorIndexes = reader.readArray(reader1 -> VectorIndex.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIndexingPolicy;
        });
    }
}

