/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import java.io.IOException;

public class GremlinDatabaseResource
implements JsonSerializable<GremlinDatabaseResource> {
    private String id;
    private ResourceRestoreParameters restoreParameters;
    private CreateMode createMode;
    private static final ClientLogger LOGGER = new ClientLogger(GremlinDatabaseResource.class);

    public String id() {
        return this.id;
    }

    public GremlinDatabaseResource withId(String id) {
        this.id = id;
        return this;
    }

    public ResourceRestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    public GremlinDatabaseResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public GremlinDatabaseResource withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model GremlinDatabaseResource"));
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("restoreParameters", (JsonSerializable)this.restoreParameters);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static GremlinDatabaseResource fromJson(JsonReader jsonReader) throws IOException {
        return (GremlinDatabaseResource)jsonReader.readObject(reader -> {
            GremlinDatabaseResource deserializedGremlinDatabaseResource = new GremlinDatabaseResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGremlinDatabaseResource.id = reader.getString();
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedGremlinDatabaseResource.restoreParameters = ResourceRestoreParameters.fromJson(reader);
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedGremlinDatabaseResource.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGremlinDatabaseResource;
        });
    }
}

