/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.DataTransferRegionalServiceResource;
import com.azure.resourcemanager.cosmos.models.ServiceResourceProperties;
import com.azure.resourcemanager.cosmos.models.ServiceSize;
import com.azure.resourcemanager.cosmos.models.ServiceStatus;
import com.azure.resourcemanager.cosmos.models.ServiceType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DataTransferServiceResourceProperties
extends ServiceResourceProperties {
    private ServiceType serviceType = ServiceType.DATA_TRANSFER;
    private List<DataTransferRegionalServiceResource> locations;

    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    public List<DataTransferRegionalServiceResource> locations() {
        return this.locations;
    }

    @Override
    public DataTransferServiceResourceProperties withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    @Override
    public DataTransferServiceResourceProperties withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    @Override
    public void validate() {
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("instanceSize", this.instanceSize() == null ? null : this.instanceSize().toString());
        jsonWriter.writeNumberField("instanceCount", (Number)this.instanceCount());
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DataTransferServiceResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DataTransferServiceResourceProperties)jsonReader.readObject(reader -> {
            DataTransferServiceResourceProperties deserializedDataTransferServiceResourceProperties = new DataTransferServiceResourceProperties();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationTime".equals(fieldName)) {
                    deserializedDataTransferServiceResourceProperties.withCreationTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("instanceSize".equals(fieldName)) {
                    deserializedDataTransferServiceResourceProperties.withInstanceSize(ServiceSize.fromString(reader.getString()));
                    continue;
                }
                if ("instanceCount".equals(fieldName)) {
                    deserializedDataTransferServiceResourceProperties.withInstanceCount((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDataTransferServiceResourceProperties.withStatus(ServiceStatus.fromString(reader.getString()));
                    continue;
                }
                if ("serviceType".equals(fieldName)) {
                    deserializedDataTransferServiceResourceProperties.serviceType = ServiceType.fromString(reader.getString());
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedDataTransferServiceResourceProperties.locations = locations = reader.readArray(reader1 -> DataTransferRegionalServiceResource.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDataTransferServiceResourceProperties.withAdditionalProperties(additionalProperties);
            return deserializedDataTransferServiceResourceProperties;
        });
    }
}

