// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The VectorIndex model.
 */
@Fluent
public final class VectorIndex implements JsonSerializable<VectorIndex> {
    /*
     * The path to the vector field in the document.
     */
    private String path;

    /*
     * The index type of the vector. Currently, flat, diskANN, and quantizedFlat are supported.
     */
    private VectorIndexType type;

    /**
     * Creates an instance of VectorIndex class.
     */
    public VectorIndex() {
    }

    /**
     * Get the path property: The path to the vector field in the document.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: The path to the vector field in the document.
     * 
     * @param path the path value to set.
     * @return the VectorIndex object itself.
     */
    public VectorIndex withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the type property: The index type of the vector. Currently, flat, diskANN, and quantizedFlat are supported.
     * 
     * @return the type value.
     */
    public VectorIndexType type() {
        return this.type;
    }

    /**
     * Set the type property: The index type of the vector. Currently, flat, diskANN, and quantizedFlat are supported.
     * 
     * @param type the type value to set.
     * @return the VectorIndex object itself.
     */
    public VectorIndex withType(VectorIndexType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (path() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property path in model VectorIndex"));
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model VectorIndex"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VectorIndex.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorIndex from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorIndex if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorIndex.
     */
    public static VectorIndex fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorIndex deserializedVectorIndex = new VectorIndex();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("path".equals(fieldName)) {
                    deserializedVectorIndex.path = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVectorIndex.type = VectorIndexType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVectorIndex;
        });
    }
}
