// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.UsageInner;
import java.io.IOException;
import java.util.List;

/**
 * The response to a list usage request.
 */
@Immutable
public final class UsagesResult implements JsonSerializable<UsagesResult> {
    /*
     * The list of usages for the database. A usage is a point in time metric
     */
    private List<UsageInner> value;

    /**
     * Creates an instance of UsagesResult class.
     */
    public UsagesResult() {
    }

    /**
     * Get the value property: The list of usages for the database. A usage is a point in time metric.
     * 
     * @return the value value.
     */
    public List<UsageInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UsagesResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UsagesResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the UsagesResult.
     */
    public static UsagesResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UsagesResult deserializedUsagesResult = new UsagesResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<UsageInner> value = reader.readArray(reader1 -> UsageInner.fromJson(reader1));
                    deserializedUsagesResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUsagesResult;
        });
    }
}
