// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The TableGetPropertiesOptions model.
 */
@Fluent
public final class TableGetPropertiesOptions extends OptionsResource {
    /**
     * Creates an instance of TableGetPropertiesOptions class.
     */
    public TableGetPropertiesOptions() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TableGetPropertiesOptions withThroughput(Integer throughput) {
        super.withThroughput(throughput);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TableGetPropertiesOptions withAutoscaleSettings(AutoscaleSettings autoscaleSettings) {
        super.withAutoscaleSettings(autoscaleSettings);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (autoscaleSettings() != null) {
            autoscaleSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("throughput", throughput());
        jsonWriter.writeJsonField("autoscaleSettings", autoscaleSettings());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TableGetPropertiesOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TableGetPropertiesOptions if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TableGetPropertiesOptions.
     */
    public static TableGetPropertiesOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TableGetPropertiesOptions deserializedTableGetPropertiesOptions = new TableGetPropertiesOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("throughput".equals(fieldName)) {
                    deserializedTableGetPropertiesOptions.withThroughput(reader.getNullable(JsonReader::getInt));
                } else if ("autoscaleSettings".equals(fieldName)) {
                    deserializedTableGetPropertiesOptions.withAutoscaleSettings(AutoscaleSettings.fromJson(reader));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTableGetPropertiesOptions;
        });
    }
}
