// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The resource of an Azure Cosmos DB MongoDB collection event.
 */
@Immutable
public final class RestorableMongodbCollectionPropertiesResource
    implements JsonSerializable<RestorableMongodbCollectionPropertiesResource> {
    /*
     * A system generated property. A unique identifier.
     */
    private String rid;

    /*
     * The operation type of this collection event.
     */
    private OperationType operationType;

    /*
     * A state of this collection to identify if this container is restorable in same account.
     */
    private String canUndelete;

    /*
     * The reason why this collection can not be restored in same account.
     */
    private String canUndeleteReason;

    /*
     * The time when this collection event happened.
     */
    private String eventTimestamp;

    /*
     * The name of this MongoDB collection.
     */
    private String ownerId;

    /*
     * The resource ID of this MongoDB collection.
     */
    private String ownerResourceId;

    /**
     * Creates an instance of RestorableMongodbCollectionPropertiesResource class.
     */
    public RestorableMongodbCollectionPropertiesResource() {
    }

    /**
     * Get the rid property: A system generated property. A unique identifier.
     * 
     * @return the rid value.
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Get the operationType property: The operation type of this collection event.
     * 
     * @return the operationType value.
     */
    public OperationType operationType() {
        return this.operationType;
    }

    /**
     * Get the canUndelete property: A state of this collection to identify if this container is restorable in same
     * account.
     * 
     * @return the canUndelete value.
     */
    public String canUndelete() {
        return this.canUndelete;
    }

    /**
     * Get the canUndeleteReason property: The reason why this collection can not be restored in same account.
     * 
     * @return the canUndeleteReason value.
     */
    public String canUndeleteReason() {
        return this.canUndeleteReason;
    }

    /**
     * Get the eventTimestamp property: The time when this collection event happened.
     * 
     * @return the eventTimestamp value.
     */
    public String eventTimestamp() {
        return this.eventTimestamp;
    }

    /**
     * Get the ownerId property: The name of this MongoDB collection.
     * 
     * @return the ownerId value.
     */
    public String ownerId() {
        return this.ownerId;
    }

    /**
     * Get the ownerResourceId property: The resource ID of this MongoDB collection.
     * 
     * @return the ownerResourceId value.
     */
    public String ownerResourceId() {
        return this.ownerResourceId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableMongodbCollectionPropertiesResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableMongodbCollectionPropertiesResource if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableMongodbCollectionPropertiesResource.
     */
    public static RestorableMongodbCollectionPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableMongodbCollectionPropertiesResource deserializedRestorableMongodbCollectionPropertiesResource
                = new RestorableMongodbCollectionPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("_rid".equals(fieldName)) {
                    deserializedRestorableMongodbCollectionPropertiesResource.rid = reader.getString();
                } else if ("operationType".equals(fieldName)) {
                    deserializedRestorableMongodbCollectionPropertiesResource.operationType
                        = OperationType.fromString(reader.getString());
                } else if ("canUndelete".equals(fieldName)) {
                    deserializedRestorableMongodbCollectionPropertiesResource.canUndelete = reader.getString();
                } else if ("canUndeleteReason".equals(fieldName)) {
                    deserializedRestorableMongodbCollectionPropertiesResource.canUndeleteReason = reader.getString();
                } else if ("eventTimestamp".equals(fieldName)) {
                    deserializedRestorableMongodbCollectionPropertiesResource.eventTimestamp = reader.getString();
                } else if ("ownerId".equals(fieldName)) {
                    deserializedRestorableMongodbCollectionPropertiesResource.ownerId = reader.getString();
                } else if ("ownerResourceId".equals(fieldName)) {
                    deserializedRestorableMongodbCollectionPropertiesResource.ownerResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableMongodbCollectionPropertiesResource;
        });
    }
}
