// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.MongoRoleDefinitionResource;
import java.io.IOException;
import java.util.List;

/**
 * Parameters to create and update an Azure Cosmos DB Mongo Role Definition.
 */
@Fluent
public final class MongoRoleDefinitionCreateUpdateParameters
    implements JsonSerializable<MongoRoleDefinitionCreateUpdateParameters> {
    /*
     * Properties to create and update an Azure Cosmos DB Mongo Role Definition.
     */
    private MongoRoleDefinitionResource innerProperties;

    /**
     * Creates an instance of MongoRoleDefinitionCreateUpdateParameters class.
     */
    public MongoRoleDefinitionCreateUpdateParameters() {
    }

    /**
     * Get the innerProperties property: Properties to create and update an Azure Cosmos DB Mongo Role Definition.
     * 
     * @return the innerProperties value.
     */
    private MongoRoleDefinitionResource innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the roleName property: A user-friendly name for the Role Definition. Must be unique for the database account.
     * 
     * @return the roleName value.
     */
    public String roleName() {
        return this.innerProperties() == null ? null : this.innerProperties().roleName();
    }

    /**
     * Set the roleName property: A user-friendly name for the Role Definition. Must be unique for the database account.
     * 
     * @param roleName the roleName value to set.
     * @return the MongoRoleDefinitionCreateUpdateParameters object itself.
     */
    public MongoRoleDefinitionCreateUpdateParameters withRoleName(String roleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withRoleName(roleName);
        return this;
    }

    /**
     * Get the type property: Indicates whether the Role Definition was built-in or user created.
     * 
     * @return the type value.
     */
    public MongoRoleDefinitionType type() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Set the type property: Indicates whether the Role Definition was built-in or user created.
     * 
     * @param type the type value to set.
     * @return the MongoRoleDefinitionCreateUpdateParameters object itself.
     */
    public MongoRoleDefinitionCreateUpdateParameters withType(MongoRoleDefinitionType type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withType(type);
        return this;
    }

    /**
     * Get the databaseName property: The database name for which access is being granted for this Role Definition.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    /**
     * Set the databaseName property: The database name for which access is being granted for this Role Definition.
     * 
     * @param databaseName the databaseName value to set.
     * @return the MongoRoleDefinitionCreateUpdateParameters object itself.
     */
    public MongoRoleDefinitionCreateUpdateParameters withDatabaseName(String databaseName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withDatabaseName(databaseName);
        return this;
    }

    /**
     * Get the privileges property: A set of privileges contained by the Role Definition. This will allow application of
     * this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than
     * Database are not enforceable as privilege.
     * 
     * @return the privileges value.
     */
    public List<Privilege> privileges() {
        return this.innerProperties() == null ? null : this.innerProperties().privileges();
    }

    /**
     * Set the privileges property: A set of privileges contained by the Role Definition. This will allow application of
     * this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than
     * Database are not enforceable as privilege.
     * 
     * @param privileges the privileges value to set.
     * @return the MongoRoleDefinitionCreateUpdateParameters object itself.
     */
    public MongoRoleDefinitionCreateUpdateParameters withPrivileges(List<Privilege> privileges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withPrivileges(privileges);
        return this;
    }

    /**
     * Get the roles property: The set of roles inherited by this Role Definition.
     * 
     * @return the roles value.
     */
    public List<Role> roles() {
        return this.innerProperties() == null ? null : this.innerProperties().roles();
    }

    /**
     * Set the roles property: The set of roles inherited by this Role Definition.
     * 
     * @param roles the roles value to set.
     * @return the MongoRoleDefinitionCreateUpdateParameters object itself.
     */
    public MongoRoleDefinitionCreateUpdateParameters withRoles(List<Role> roles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withRoles(roles);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MongoRoleDefinitionCreateUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MongoRoleDefinitionCreateUpdateParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MongoRoleDefinitionCreateUpdateParameters.
     */
    public static MongoRoleDefinitionCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MongoRoleDefinitionCreateUpdateParameters deserializedMongoRoleDefinitionCreateUpdateParameters
                = new MongoRoleDefinitionCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedMongoRoleDefinitionCreateUpdateParameters.innerProperties
                        = MongoRoleDefinitionResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMongoRoleDefinitionCreateUpdateParameters;
        });
    }
}
