// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB Gremlin graph resource object.
 */
@Fluent
public class GremlinGraphResource implements JsonSerializable<GremlinGraphResource> {
    /*
     * Name of the Cosmos DB Gremlin graph
     */
    private String id;

    /*
     * The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the
     * graph
     */
    private IndexingPolicy indexingPolicy;

    /*
     * The configuration of the partition key to be used for partitioning data into multiple partitions
     */
    private ContainerPartitionKey partitionKey;

    /*
     * Default time to live
     */
    private Integer defaultTtl;

    /*
     * The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the
     * Azure Cosmos DB service.
     */
    private UniqueKeyPolicy uniqueKeyPolicy;

    /*
     * The conflict resolution policy for the graph.
     */
    private ConflictResolutionPolicy conflictResolutionPolicy;

    /*
     * Analytical TTL.
     */
    private Long analyticalStorageTtl;

    /*
     * Parameters to indicate the information about the restore
     */
    private ResourceRestoreParameters restoreParameters;

    /*
     * Enum to indicate the mode of resource creation.
     */
    private CreateMode createMode;

    /**
     * Creates an instance of GremlinGraphResource class.
     */
    public GremlinGraphResource() {
    }

    /**
     * Get the id property: Name of the Cosmos DB Gremlin graph.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Name of the Cosmos DB Gremlin graph.
     * 
     * @param id the id value to set.
     * @return the GremlinGraphResource object itself.
     */
    public GremlinGraphResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the indexingPolicy property: The configuration of the indexing policy. By default, the indexing is automatic
     * for all document paths within the graph.
     * 
     * @return the indexingPolicy value.
     */
    public IndexingPolicy indexingPolicy() {
        return this.indexingPolicy;
    }

    /**
     * Set the indexingPolicy property: The configuration of the indexing policy. By default, the indexing is automatic
     * for all document paths within the graph.
     * 
     * @param indexingPolicy the indexingPolicy value to set.
     * @return the GremlinGraphResource object itself.
     */
    public GremlinGraphResource withIndexingPolicy(IndexingPolicy indexingPolicy) {
        this.indexingPolicy = indexingPolicy;
        return this;
    }

    /**
     * Get the partitionKey property: The configuration of the partition key to be used for partitioning data into
     * multiple partitions.
     * 
     * @return the partitionKey value.
     */
    public ContainerPartitionKey partitionKey() {
        return this.partitionKey;
    }

    /**
     * Set the partitionKey property: The configuration of the partition key to be used for partitioning data into
     * multiple partitions.
     * 
     * @param partitionKey the partitionKey value to set.
     * @return the GremlinGraphResource object itself.
     */
    public GremlinGraphResource withPartitionKey(ContainerPartitionKey partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    /**
     * Get the defaultTtl property: Default time to live.
     * 
     * @return the defaultTtl value.
     */
    public Integer defaultTtl() {
        return this.defaultTtl;
    }

    /**
     * Set the defaultTtl property: Default time to live.
     * 
     * @param defaultTtl the defaultTtl value to set.
     * @return the GremlinGraphResource object itself.
     */
    public GremlinGraphResource withDefaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    /**
     * Get the uniqueKeyPolicy property: The unique key policy configuration for specifying uniqueness constraints on
     * documents in the collection in the Azure Cosmos DB service.
     * 
     * @return the uniqueKeyPolicy value.
     */
    public UniqueKeyPolicy uniqueKeyPolicy() {
        return this.uniqueKeyPolicy;
    }

    /**
     * Set the uniqueKeyPolicy property: The unique key policy configuration for specifying uniqueness constraints on
     * documents in the collection in the Azure Cosmos DB service.
     * 
     * @param uniqueKeyPolicy the uniqueKeyPolicy value to set.
     * @return the GremlinGraphResource object itself.
     */
    public GremlinGraphResource withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        return this;
    }

    /**
     * Get the conflictResolutionPolicy property: The conflict resolution policy for the graph.
     * 
     * @return the conflictResolutionPolicy value.
     */
    public ConflictResolutionPolicy conflictResolutionPolicy() {
        return this.conflictResolutionPolicy;
    }

    /**
     * Set the conflictResolutionPolicy property: The conflict resolution policy for the graph.
     * 
     * @param conflictResolutionPolicy the conflictResolutionPolicy value to set.
     * @return the GremlinGraphResource object itself.
     */
    public GremlinGraphResource withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        this.conflictResolutionPolicy = conflictResolutionPolicy;
        return this;
    }

    /**
     * Get the analyticalStorageTtl property: Analytical TTL.
     * 
     * @return the analyticalStorageTtl value.
     */
    public Long analyticalStorageTtl() {
        return this.analyticalStorageTtl;
    }

    /**
     * Set the analyticalStorageTtl property: Analytical TTL.
     * 
     * @param analyticalStorageTtl the analyticalStorageTtl value to set.
     * @return the GremlinGraphResource object itself.
     */
    public GremlinGraphResource withAnalyticalStorageTtl(Long analyticalStorageTtl) {
        this.analyticalStorageTtl = analyticalStorageTtl;
        return this;
    }

    /**
     * Get the restoreParameters property: Parameters to indicate the information about the restore.
     * 
     * @return the restoreParameters value.
     */
    public ResourceRestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    /**
     * Set the restoreParameters property: Parameters to indicate the information about the restore.
     * 
     * @param restoreParameters the restoreParameters value to set.
     * @return the GremlinGraphResource object itself.
     */
    public GremlinGraphResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    /**
     * Get the createMode property: Enum to indicate the mode of resource creation.
     * 
     * @return the createMode value.
     */
    public CreateMode createMode() {
        return this.createMode;
    }

    /**
     * Set the createMode property: Enum to indicate the mode of resource creation.
     * 
     * @param createMode the createMode value to set.
     * @return the GremlinGraphResource object itself.
     */
    public GremlinGraphResource withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model GremlinGraphResource"));
        }
        if (indexingPolicy() != null) {
            indexingPolicy().validate();
        }
        if (partitionKey() != null) {
            partitionKey().validate();
        }
        if (uniqueKeyPolicy() != null) {
            uniqueKeyPolicy().validate();
        }
        if (conflictResolutionPolicy() != null) {
            conflictResolutionPolicy().validate();
        }
        if (restoreParameters() != null) {
            restoreParameters().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GremlinGraphResource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("indexingPolicy", this.indexingPolicy);
        jsonWriter.writeJsonField("partitionKey", this.partitionKey);
        jsonWriter.writeNumberField("defaultTtl", this.defaultTtl);
        jsonWriter.writeJsonField("uniqueKeyPolicy", this.uniqueKeyPolicy);
        jsonWriter.writeJsonField("conflictResolutionPolicy", this.conflictResolutionPolicy);
        jsonWriter.writeNumberField("analyticalStorageTtl", this.analyticalStorageTtl);
        jsonWriter.writeJsonField("restoreParameters", this.restoreParameters);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GremlinGraphResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GremlinGraphResource if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GremlinGraphResource.
     */
    public static GremlinGraphResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GremlinGraphResource deserializedGremlinGraphResource = new GremlinGraphResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGremlinGraphResource.id = reader.getString();
                } else if ("indexingPolicy".equals(fieldName)) {
                    deserializedGremlinGraphResource.indexingPolicy = IndexingPolicy.fromJson(reader);
                } else if ("partitionKey".equals(fieldName)) {
                    deserializedGremlinGraphResource.partitionKey = ContainerPartitionKey.fromJson(reader);
                } else if ("defaultTtl".equals(fieldName)) {
                    deserializedGremlinGraphResource.defaultTtl = reader.getNullable(JsonReader::getInt);
                } else if ("uniqueKeyPolicy".equals(fieldName)) {
                    deserializedGremlinGraphResource.uniqueKeyPolicy = UniqueKeyPolicy.fromJson(reader);
                } else if ("conflictResolutionPolicy".equals(fieldName)) {
                    deserializedGremlinGraphResource.conflictResolutionPolicy
                        = ConflictResolutionPolicy.fromJson(reader);
                } else if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedGremlinGraphResource.analyticalStorageTtl = reader.getNullable(JsonReader::getLong);
                } else if ("restoreParameters".equals(fieldName)) {
                    deserializedGremlinGraphResource.restoreParameters = ResourceRestoreParameters.fromJson(reader);
                } else if ("createMode".equals(fieldName)) {
                    deserializedGremlinGraphResource.createMode = CreateMode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGremlinGraphResource;
        });
    }
}
