// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The list of new failover policies for the failover priority change.
 */
@Fluent
public final class FailoverPolicies implements JsonSerializable<FailoverPolicies> {
    /*
     * List of failover policies.
     */
    private List<FailoverPolicy> failoverPolicies;

    /**
     * Creates an instance of FailoverPolicies class.
     */
    public FailoverPolicies() {
    }

    /**
     * Get the failoverPolicies property: List of failover policies.
     * 
     * @return the failoverPolicies value.
     */
    public List<FailoverPolicy> failoverPolicies() {
        return this.failoverPolicies;
    }

    /**
     * Set the failoverPolicies property: List of failover policies.
     * 
     * @param failoverPolicies the failoverPolicies value to set.
     * @return the FailoverPolicies object itself.
     */
    public FailoverPolicies withFailoverPolicies(List<FailoverPolicy> failoverPolicies) {
        this.failoverPolicies = failoverPolicies;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (failoverPolicies() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property failoverPolicies in model FailoverPolicies"));
        } else {
            failoverPolicies().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FailoverPolicies.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("failoverPolicies", this.failoverPolicies,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FailoverPolicies from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FailoverPolicies if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FailoverPolicies.
     */
    public static FailoverPolicies fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FailoverPolicies deserializedFailoverPolicies = new FailoverPolicies();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("failoverPolicies".equals(fieldName)) {
                    List<FailoverPolicy> failoverPolicies
                        = reader.readArray(reader1 -> FailoverPolicy.fromJson(reader1));
                    deserializedFailoverPolicies.failoverPolicies = failoverPolicies;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFailoverPolicies;
        });
    }
}
